% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_districts.R
\name{get_districts}
\alias{get_districts}
\title{Download the districts limits of INEI}
\usage{
get_districts(dsn = NULL, show_progress = TRUE, quiet = TRUE)
}
\arguments{
\item{dsn}{Character. Output filename with the \bold{*.gpkg} format. If missing, a temporary file is created.}

\item{show_progress}{Logical. Suppress bar progress.}

\item{quiet}{Logical. Suppress info message.}
}
\value{
A sf object.
}
\description{
This function allows you to download the latest version of the \bold{geometry} and \bold{ubigeos}
corresponding to the \bold{official political division} of the district boundaries of Peru.
For more information, you can visit the following page \url{https://ide.inei.gob.pe/}
}
\examples{
\donttest{
library(geoidep)
dist <- get_districts(show_progress = FALSE)
head(dist)
}
}
