% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-simplegeom-obj.R
\docType{methods}
\name{simplegeom}
\alias{simplegeom}
\alias{simplegeom,ANY-method}
\alias{simplegeom,missing-method}
\title{Create simplegeom object}
\usage{
simplegeom(.Object, ...)

\S4method{simplegeom}{missing}(.Object, ...)

\S4method{simplegeom}{ANY}(.Object, ...)
}
\arguments{
\item{.Object}{any object that can be coerced into \linkS4class{simplegeom}}

\item{...}{additional arguments passed to SpatialPolygonsDataFrame}
}
\value{
the simplegeom object
}
\description{
A simple geom is a simple set of geometries specified locally. See 
\code{\link{webgeom}} for web features.
}
\examples{
simplegeom(c(-88.6, 45.2))
\dontrun{
library(sp)
Sr1 <- Polygon(cbind(c(-89.0001,-89,-88.9999,-89,-89.0001),c(46,46.0001,46,45.9999,46)))
Sr2 <- Polygon(cbind(c(-88.6,-88.5999,-88.5999,-88.6,-88.6),c(45.2,45.2,45.1999,45.1999,45.2)))
Srs1 <- Polygons(list(Sr1), "s1")
Srs2 <- Polygons(list(Sr2), "s2")
SP <- SpatialPolygons(list(Srs1,Srs2), proj4string = CRS("+proj=longlat +datum=WGS84"))
result(geoknife(simplegeom(SP), 'prism', wait=TRUE))
}
simplegeom(data.frame('point1'=c(-89, 46), 'point2'=c(-88.6, 45.2)))
}
\author{
Jordan S Read
}

