% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contiguity.R
\name{suggest_component_connection}
\alias{suggest_component_connection}
\title{Suggest Connections for Disconnected Groups}
\usage{
suggest_component_connection(shp, adjacency, group)
}
\arguments{
\item{shp}{An sf data frame}

\item{adjacency}{adjacency list}

\item{group}{array of group identifiers. Typically district numbers or county names. 
Defaults to rep(1, length(adjacency)) if missing.}
}
\value{
tibble with two columns of suggested rows of shp to connect in adj
}
\description{
Suggests nearest neighbors for connecting a disconnected group.
}
\examples{
library(dplyr)
data(checkerboard)
checkerboard <- checkerboard \%>\% filter(i != 1, j != 1)
adj <- adjacency(checkerboard)
suggest_component_connection(checkerboard, adj)

}
\concept{fix}
