% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMLDerivedUnit.R
\docType{class}
\name{GMLDerivedUnit}
\alias{GMLDerivedUnit}
\title{GMLDerivedUnit}
\format{\code{\link{R6Class}} object.}
\usage{
GMLDerivedUnit
}
\value{
Object of \code{\link{R6Class}} for modelling an GML derived unit
}
\description{
GMLDerivedUnit
}
\section{Fields}{

\describe{
\item{\code{derivationUnitTerm}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml, defaults, id)}}{
   This method is used to instantiate a GML Base Unit
 }
 \item{\code{addDerivationUnitTerm(uom, exponent)}}{
   Adds a derivation unit term, made of a uom reference, and an exponent which
   can be negative/positive but not equal to zero.
 }
 \item{\code{delDerivationUnitTerm(uom, exponent)}}{
   Deletes a derivation unit term
 }
}
}

\examples{
  gml <- GMLDerivedUnit$new()
  gml$setDescriptionReference("someref")
  gml$setIdentifier("identifier", "codespace")
  gml$addName("name2", "codespace")
  gml$setQuantityTypeReference("someref")
  gml$setCatalogSymbol("symbol")
  gml$addDerivationUnitTerm("uomId", 2L)

}
\references{
ISO 19136:2007 Geographic Information -- Geographic Markup Language.
  http://www.iso.org/iso/iso_catalogue/catalogue_tc/catalogue_detail.htm?csnumber=32554 
  
  OGC Geography Markup Language. http://www.opengeospatial.org/standards/gml
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{GML}
\keyword{ISO}
\keyword{definition}
\keyword{derived}
\keyword{unit}
