% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISODistributor.R
\docType{class}
\name{ISODistributor}
\alias{ISODistributor}
\title{ISODistributor}
\format{\code{\link{R6Class}} object.}
\usage{
ISODistributor
}
\value{
Object of \code{\link{R6Class}} for modelling an ISODistributor
}
\description{
ISODistributor
}
\section{Fields}{

\describe{
\item{\code{distributorFormat}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISODistributor
 }
 \item{\code{setContact(contact)}}{
   Sets the contact \code{ISOResponsibleParty}
 }
 \item{\code{addFormat(format)}}{
   Adds a distributor format \code{ISOFormat}
 }
 \item{\code{delFormat(format)}}{
   Deletes a distributor format \code{ISOFormat}
 }
}
}

\examples{
   md <- ISODistributor$new()
   rp <- ISOResponsibleParty$new()
   rp$setIndividualName("someone")
   rp$setOrganisationName("somewhere")
   rp$setPositionName("Data manager")
   
   contact <- ISOContact$new()
   phone <- ISOTelephone$new()
   phone$setVoice("myphonenumber")
   phone$setFacsimile("myfacsimile")
   contact$setPhone(phone)
   address <- ISOAddress$new()
   address$setDeliveryPoint("theaddress")
   address$setCity("thecity")
   address$setPostalCode("111")
   address$setCountry("France")
   address$setEmail("someone@theorg.org")
   contact$setAddress(address)
   res <- ISOOnlineResource$new()
   res$setLinkage("http://www.somewhereovertheweb.org")
   res$setName("somename")
   contact$setOnlineResource(res)
   rp$setContactInfo(contact)
   rp$setRole("author")
   md$setContact(rp)
   
   format <- ISOFormat$new()
   format$setName("name")
   format$setVersion("1.0")
   format$setAmendmentNumber("2")
   format$setSpecification("specification")
   md$addFormat(format)
   
   xml <- md$encode()
 
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{distributor}
