% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImagerySource.R
\docType{class}
\name{ISOImagerySource}
\alias{ISOImagerySource}
\title{ISOImagerySource}
\format{\code{\link{R6Class}} object.}
\usage{
ISOImagerySource
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery source
}
\description{
ISOImagerySource
}
\section{Fields}{

\describe{
\item{\code{processedLevel}}{[\code{\link{ISOMetaIdentifier}}]}

\item{\code{resolution}}{[\code{\link{ISOImageryNominalResolution}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImagerySource}}
 }
 \item{\code{setProcessedLevel(processedLevel)}}{
   Sets processed level, object of class \code{character} or \code{\link{ISOMetaIdentifier}}
 }
 \item{\code{setResolution(resolution)}}{
   Set the resolution, object of class \code{ISOImageryNominalResolution}
 }
}
}

\examples{
   md <- ISOImagerySource$new()
   md$setProcessedLevel("identifier")
   res <- ISOImageryNominalResolution$new()
   d <- ISODistance$new(value = 1, uom = "m", useUomURI = TRUE)
   res$setScanningResolution(d)
   md$setResolution(res)
   
   xml <- md$encode()

}
\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{imagery}
\keyword{source}
