% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOMetadataExtensionInformation.R
\docType{class}
\name{ISOMetadataExtensionInformation}
\alias{ISOMetadataExtensionInformation}
\title{ISOMetadataExtensionInformation}
\format{\code{\link{R6Class}} object.}
\usage{
ISOMetadataExtensionInformation
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO MetadataExtensionInformation
}
\description{
ISOMetadataExtensionInformation
}
\section{Fields}{

\describe{
\item{\code{extensionOnLineResource}}{[\code{\link{ISOOnlineResource}}] online resource}

\item{\code{extendedElementInformation}}{[\code{\link{ISOExtendedElementInformation}}] extended element(s)}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOMetadataExtensionInformation}}
 }
 \item{\code{setOnlineResource(onlineResource)}}{
   Sets an online resource (object of class \code{\link{ISOOnlineResource}})
 }
 \item{\code{addElement(element)}}{
   Adds an element (object of class \code{\link{ISOExtendedElementInformation}})
 }
 \item{\code{delElement(element)}}{
   Deletes an element (object of class \code{\link{ISOExtendedElementInformation}})
 }
}
}

\examples{
  #create an extended element information
  elem <- ISOExtendedElementInformation$new()
  elem$setName("name")
  elem$setShortName("shortName")
  elem$setDomainCode(1L)
  elem$setDefinition("some definition")
  elem$setObligation("mandatory")
  elem$setCondition("no condition")
  elem$setDatatype("characterString")
  elem$setMaximumOccurrence("string")
  elem$setDomainValue("value")
  elem$addParentEntity("none")
  elem$setRule("rule")
  elem$addRationale("rationale")
  rp <- ISOResponsibleParty$new()
  rp$setIndividualName("someone")
  rp$setOrganisationName("somewhere")
  rp$setPositionName("someposition")
  rp$setRole("pointOfContact")
  contact <- ISOContact$new()
  phone <- ISOTelephone$new()
  phone$setVoice("myphonenumber")
  phone$setFacsimile("myfacsimile")
  contact$setPhone(phone)
  address <- ISOAddress$new()
  address$setDeliveryPoint("theaddress")
  address$setCity("thecity")
  address$setPostalCode("111")
  address$setCountry("France")
  address$setEmail("someone@theorg.org")
  contact$setAddress(address)
  res <- ISOOnlineResource$new()
  res$setLinkage("http://www.somewhereovertheweb.org")
  res$setName("somename")
  contact$setOnlineResource(res)
  rp$setContactInfo(contact)
  elem$addSource(rp)
  
  md <- ISOMetadataExtensionInformation$new()
  md$addElement(elem)
  
  xml <- md$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{extension}
\keyword{information}
\keyword{metadata}
