% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometa_mapping.R
\docType{class}
\name{pivot_format}
\alias{pivot_format}
\title{pivot_format}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a mapping format
}
\description{
pivot_format
}
\section{Fields}{

\describe{
\item{\code{id}}{(character) format identifier}

\item{\code{pkg}}{(character) package(s) required for the format}

\item{\code{reader}}{(function) handler used for reading a property}

\item{\code{checker}}{(function) handler used for checking a property value}

\item{\code{constructor}}{(function) handler used for object construction}
}}

\section{Methods}{

\describe{
 \item{\code{new(id, pkg, reader, checker, constructor)}}{
   This method is used to instantiate a pivot_format, given a unique \code{id},
   the name of package used (for information only). A format is then defined by
   string expressions (using \code{sprintf} formatting) to read metadata properties
   (\code{reader}), one for checking existence of properties (\code{checker}), and an
   expression to create metadata objects (\code{constructor}). In case the \code{constructor}
   is NULL, then no conversion to this metadata format will be possible.
 }
}
}

\examples{
  #example on how geometa format is defined as pivot format
  pivot_format$new(
    id = "geometa", pkg = "geometa",
    reader = "\%s[[\%s]]", checker = "!is.null(\%s[[\%s]])",
    constructor = "ISOMetadata$new"
  )

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{convert}
\keyword{mapping}
\keyword{metadata}
