% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_tiles.R
\name{gs_tiles}
\alias{gs_tiles}
\title{Create a regular tiling \code{geom}}
\usage{
gs_tiles(anchor = NULL, width = NULL, pattern = "squared", centroids = FALSE)
}
\arguments{
\item{anchor}{[\code{geom(1)}|\code{data.frame(1)}]\cr Object to derive the
tiling \code{geom} from. It must include column names \code{x}, \code{y}
and optionally a custom \code{fid}.}

\item{width}{[\code{numeric(1)}]\cr the width (which does not correspond to
the height in case of \code{pattern = "hexagonal"}) of a tile.}

\item{pattern}{[\code{character(1)}]\cr pattern of the tiling. Possible
options are \code{"squared"} (default) or \code{"hexagonal"}.}

\item{centroids}{[\code{logical(1)}]\cr should the centroids of the tiling be
returned (\code{TRUE}) or should the tiling be returned (\code{FALSE},
default)?}
}
\value{
A \code{geom}.
}
\description{
Create a regular tiling polygon geometry (of class \code{geom}) for the
extent of an anchor value.
}
\details{
When deriving a regular tiling for a prescribed window, there is
  only a limited set of legal combinations of cells in x and y dimension. For
  instance, a window of 100 by 100 can't comprise 10 by 5 squares of
  side-length/width 10, because then the y-dimension wouldn't be fully covered. The
  same is true for hexagonal and triangular tilings.
}
\examples{
# create a squared tiling
aWindow <- data.frame(x = c(-180, 180),
                      y = c(-60, 80))
tiles <- gs_tiles(anchor = aWindow, width = 10)
visualise(`10° world tiles` = tiles)

# create a hexagonal tiling on top of a geom
coords <- data.frame(x = c(40, 70, 70, 50),
                     y = c(40, 40, 60, 70))
window <- data.frame(x = c(0, 80),
                     y = c(0, 80))
aGeom <- gs_polygon(anchor = coords, window = window)
visualise(`honeycomb background` = aGeom)
hex <- gs_tiles(anchor = aGeom, width = 8, pattern = "hexagonal")
visualise(hex, linecol = "deeppink", new = FALSE)
}
\seealso{
Other tilings: 
\code{\link{gs_voronoi}()}
}
\concept{tilings}
