% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{football}
\alias{football}
\title{College football games network (undirected)}
\format{A list of two data frames:
\itemize{
\item the edges data set consists of three variables of length 613:
\itemize{
  \item from, to: Character variables describing the teams playing in the game
  \item same.conf: An indicator variable that is 1 if the two teams are in the same conference and 0 otherwise.
}
\item the vertices data set consists of two variables with information on 115 Division I schools:
\itemize{
  \item label: Character variable containing the school names
  \item value: Character variable containing the conference of the schools
}
}}
\usage{
football
}
\description{
A list of two datasets, vertices and edges, containing data on Division I college football games in the Fall 2000 season.
The variables are as follows:
}
\examples{
# data step: merge vertices and edges
ftnet <- merge(
  football$edges, football$vertices,
  by.x = "from", by.y = "label", all = TRUE
)

# label independent schools
ftnet$schools <- ifelse(ftnet$value == "Independents", ftnet$from, "")

# create data plot
ggplot(data = ftnet,
       aes(from_id = from, to_id = to)) +
  geom_net(
    aes(
      colour = value, group = value,
      linetype = factor(same.conf != 1),
      label = schools
    ),
    linewidth = 0.5,
    size = 5, vjust = -0.75, alpha = 0.3,
    layout = 'fruchtermanreingold'
  ) +
  theme_net() +
  theme(legend.position = "bottom") +
  scale_colour_brewer("Conference", palette = "Paired")  +
  guides(linetype = FALSE)
}
\references{
M. Girvan and M. E. J. Newman, Proc. Natl. Acad. Sci. USA 99, 7821-7826 (2002).
}
\keyword{datasets}

