% Generated by roxygen2 (4.0.2): do not edit by hand
\name{warpRefOutline}
\alias{warpRefOutline}
\title{Creates a 2D outline warped to the mean shape.}
\usage{
warpRefOutline(file, coord, ref)
}
\arguments{
\item{file}{A .txt or .csv file of the outline point coordinates, or a .TPS file with OUTLINES= or CURVES= elements}

\item{coord}{A p x k matrix of 2D fixed landmark coordinates}

\item{ref}{A p x k matrix of 2D coordinates made by \code{\link{mshape}}}
}
\value{
Function returns an outline object
}
\description{
A function to take an outline (defined by many points) and use thin-plate spline method to warp the outline
into the estimated mean shape for a set of aligned specimens.
}
\details{
Function takes an outline (defined by many points) with a set of fixed landmark coordinates and uses the thin-plate spline method (Bookstein 1989)
to warp the outline into the shape defined by a second set of landmark coordinates, usually those of the
mean shape for a set of aligned specimens. It is highly recommended that the mean shape is used as the
reference for warping (see Rohlf 1998). The workflow is as follows:
\enumerate{
\item {Calculate the mean shape using \code{\link{mshape}}}
\item{Choose an actual specimen to use for the warping. The specimen used as the template for this warping
is recommended as one most similar in shape to the average of the sample, but can be any reasonable
specimen - do this by eye, or use \code{\link{findMeanSpec}} }
\item{Warp this specimen into the mean shape using \code{\link{warpRefOutline}} }
\item{Use this average outline where it asks for a outline= in the analysis functions and visualization functions  }
}
The returned outline object is for use in geomorph
functions where shape deformations are plotted (\code{\link{plotTangentSpace}},
\code{\link{plotAllometry}}, \code{\link{bilat.symmetry}}, and \code{\link{plotRefToTarget}}).
}
\author{
Emma Sherratt
}
\references{
Bookstein, F. L. 1989 Principal Warps: Thin-Plate Splines and the Decomposition
of Deformations. IEEE Transactions on Pattern Analysis and Machine Intelligence 11(6):567-585.

Rohlf, F. J. 1998. On Applications of Geometric Morphometrics to Studies of Ontogeny and Phylogeny. Systematic Biology. 47:147-158.
}
\seealso{
\code{\link{findMeanSpec}}
}
\keyword{utilities}
\keyword{visualization}

