% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/warpRefMesh.R
\name{warpRefMesh}
\alias{warpRefMesh}
\title{Creates a mesh3d object warped to the mean shape.}
\usage{
warpRefMesh(file, mesh.coord, ref, color = NULL, centered = FALSE)
}
\arguments{
\item{file}{An ASCII ply file}

\item{mesh.coord}{A p x k matrix of 3D coordinates digitized on the ply file.}

\item{ref}{A p x k matrix of 3D coordinates made by \code{\link{mshape}}}

\item{color}{Color to set the ply file $material. If the ply already has color, use NULL.
For ply files without color, color=NULL will be plotted as grey.}

\item{centered}{Logical If the data in mesh.coords were collected from a centered mesh (see details).}
}
\value{
Function returns a mesh3d object, which is a list of class mesh3d (see rgl for details)
}
\description{
A function to take a ply file and use thin-plate spline method to warp the file
into the estimated mean shape for a set of aligned specimens.
}
\details{
Function takes a ply file and its landmark coordinates uses the thin-plate spline method (Bookstein 1989)
to warp the mesh into the shape defined by a second set of landmark coordinates, usually those of the
mean shape for a set of aligned specimens. It is highly recommended that the mean shape is used as the
reference for warping (see Rohlf 1998). The workflow is as follows:
\enumerate{
\item {Calculate the mean shape using \code{\link{mshape}}}
\item{Choose an actual specimen to use for the warping. The specimen used as the template for this warping
is recommended as one most similar in shape to the average of the sample, but can be any reasonable
specimen - do this by eye, or use \code{\link{findMeanSpec}} }
\item{Warp this specimen into the mean shape using \code{\link{warpRefMesh}} }
\item{Use this average mesh where it asks for a mesh= in the analysis functions and visualization functions  }
}

For landmark coordinates digitized with geomorph digitizing functions, centered = TRUE. This refers to the
specimen being centered prior to landmark acquisition in the RGL window. For landmark data collected outside
of geomorph, centered=FALSE will usually be the case. The returned mesh3d object is for use in geomorph
functions where shape deformations are plotted (\code{\link{plotTangentSpace}},
\code{\link{plotAllometry}}, \code{\link{bilat.symmetry}}, and \code{\link{plotRefToTarget}}).
}
\author{
Emma Sherratt
}
\references{
Bookstein, F. L. 1989 Principal Warps: Thin-Plate Splines and the Decomposition
of Deformations. IEEE Transactions on Pattern Analysis and Machine Intelligence 11(6):567-585.

Rohlf, F. J. 1998. On Applications of Geometric Morphometrics to Studies of Ontogeny and Phylogeny. Systematic Biology. 47:147-158.
}
\seealso{
\code{\link{findMeanSpec}}
}
\keyword{utilities}
\keyword{visualization}

