% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords.subset.r
\name{coords.subset}
\alias{coords.subset}
\title{Subset landmark coordinates via a factor}
\usage{
coords.subset(A, group)
}
\arguments{
\item{A}{A 3D array (p x k x n) containing landmark coordinates for a set of specimens}

\item{group}{A grouping factor of length n, for splitting the array into sub-arrays}
}
\description{
Subset (split) landmark coordinates via a grouping factor
}
\details{
This function splits a set of landmark coordinates into subsets, as described by a factor.  The 
results is a list of separate sets of landmarks.
}
\examples{
data(pupfish) 
group <- factor(paste(pupfish$Pop, pupfish$Sex))
levels(group)
new.coords <- coords.subset(A = pupfish$coords, group = group)
names(new.coords) # see the list levels
# access any element by:

}
\author{
Michael Collyer
}
\keyword{utilities}
