% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define.sliders.r
\name{define.sliders}
\alias{define.sliders}
\title{Select points to "slide" along curves}
\usage{
define.sliders(landmarks, nsliders, surfsliders = NULL, write.file = TRUE)
}
\arguments{
\item{landmarks}{A matrix containing 2D or 3D landmark coordinates of landmarks and semilandmarks, OR A vector containing a sequence of numbers corresponding to the landmarks in the order they appear along the curve (for AUTO mode)}

\item{nsliders}{Number of landmarks to be semilandmarks that slide along curves}

\item{surfsliders}{(3D only) If 'landmarks' contains "surface sliders",
e.g. made by \code{\link{buildtemplate}}, these should be given as a vector or use surfsliders = T, and function looks for "surfslide.csv" in working directory.}

\item{write.file}{A logical value indicating whether the matrix is written to file as .csv.}
}
\value{
Function returns a 'nsliders-x-3' matrix containing the landmark address of the curve sliders, indicating the landmarks between which the slider landmarks will "slide". If write.file = T the matrix is also written to working directory as "curveslide.csv". Matrix (or "curveslide.csv") is designed for use by \code{\link{gpagen}} during GPA.
}
\description{
An interactive function to define which landmarks will "slide" along two-dimensional (2D) or
three-dimensional (3D) curves.
}
\details{
Function takes a matrix of digitized landmark coordinates, such as made by \code{\link{digitize2d}} or \code{\link{digit.fixed}},
 and helps user choose which landmarks will be treated as "sliders" in Generalized Procrustes analysis
 \code{\link{gpagen}}. This type of semilandmark "slides" along curves lacking known landmarks 
 (see Bookstein 1997 for algorithm details). 
 Each sliding semilandmark ("sliders") will slide between two designated points, along a line 
 tangent to the specified curvature.
 
Defining landmarks is an interactive procedure (see below for 2D and 3D routines). The procedure is overlapping. 
For example: there are 5 landmarks (1:5), 1 and 5 are landmarks and 2,3,4 are sliders,
the user must select '1' '2' '3', and then '2' '3' '4', and then '3' '4' '5'.

\subsection{Selection in 2D}{ 
Choosing which landmarks will be sliders involves landmark selection using a mouse in the plot window. 
To define the sliders, for each sliding landmark along the curve in the format 'before-slider-after',
using the LEFT mouse button (or regular button for Mac users), click on the hollow circle to choose the landmark
in the following order:
\enumerate{
 \item Click to choose the first landmark between which semi-landmark will "slide",
 \item Click to choose sliding landmark,
 \item Click to choose the last landmark between which semi-landmark will "slide",
 Selected landmarks will be filled in and lines are drawn connecting the three landmarks, 
 and will highlight the sliding semilandmark in red and the flanking landmarks in blue. 
} }

\subsection{Selection in 3D}{ 
Choosing which landmarks will be sliders involves landmark selection using a mouse in the rgl plot window. 
With a standard 3-button (PC) buildtemplate uses:
\enumerate{
 \item the RIGHT mouse button (primary) to choose points to be defined as sliders,
 \item the LEFT mouse button (secondary) is used to rotate mesh, 
 \item the mouse SCROLLER (third/middle) is used to zoom in and out.
}
NOTE: Digitizing functions on MACINTOSH computers using a standard 3-button mice works as specified. Macs using platform 
specific single button mice, XQuartz must be configured: go to Preferences > Input > tick "Emulate three button mouse":
\enumerate{
 \item press button to rotate 3D mesh,
 \item press button while pressing COMMAND key to select points to be defined as sliders,
 \item press button while pressing OPTION key to adjust mesh perspective.
 \item the mouse SCROLLER or trackpad two finger scroll is used to zoom in an out.
 }

To define the sliders, for each sliding landmark along the curve in the format 'before-slider-after':
\enumerate{
 \item Click to choose the first landmark between which semi-landmark will "slide",
 \item Click to choose sliding landmark,
 \item Click to choose the last landmark between which semi-landmark will "slide",
Screen will show lines connecting the three landmarks, and will highlight the sliding semilandmark in red. 
} }

\subsection{AUTO mode}{ 
The input 'landmarks' can be simply a vector of numbers corresponding to the "sliders" (semilandmarks) in the order they appear along a curve on the specimen. This can be made by c() or seq() or any other reasonable method.
 
 If the sliders form a closed curve, then the function assumes that the first and last landmarks in the 'landmarks' vector are THE SAME are fixed (not sliders). e.g. if landmark 1 is a fixed landmark, and 2, 3 and 4 are semilandmarks, then sliders = c(1,2,3,4,1).
}
}
\examples{
 
## (not run) Use interactive function in rgl window
 # data(scallops)
 # define.sliders(scallops$coorddata[,,1], nsliders=11,surfsliders = scallops$surfslide) 
 # here the first specimen is used for plotting purposes only
 
## Examples of AUTO mode 
 ## 1 curve of sliding semilandmark
 # Define sliders for scallopdata
 sliders = define.sliders(c(5:16,1))

 ## 2 curves of sliding semilandmarks
 # Define sliders for 10 landmarks, where LMs 1, 5, and 10 fixed
 # 2, 3, and 4 are along a curve between 1 and 5
 # and 6, 7, 8, and 9 are along a curve between 5 and 10.
 sliders = rbind(define.sliders(1:5), define.sliders(5:10)) 
}
\references{
Bookstein, F. J. 1997 Landmark Methods for Forms without Landmarks: Morphometrics of 
Group Differences in Outline Shape. Medical Image Analysis 1(3):225-243.
}
\seealso{
\code{\link{digitize2d}}, \code{\link{digit.fixed}}, \code{\link{gpagen}}, \code{\link{digit.curves}}

\code{\link[rgl]{rgl-package}} (used in 3D plotting)
}
\author{
Emma Sherratt & Dean Adams
}
\keyword{utilities}
