% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.ZVrel.R
\name{compare.ZVrel}
\alias{compare.ZVrel}
\title{Comparisons of Effect Sizes from Overall Integration Analyses}
\usage{
compare.ZVrel(..., two.tailed = TRUE)
}
\arguments{
\item{...}{saved analyses of class rel.eig}

\item{two.tailed}{A logical value to indicate whether a two-tailed test (typical and default) should be performed.}
}
\value{
An object of class compare.rel.eig, returns a list of the following

\item{sample.Re.obs}{A vector of observed Vrel for each sample.}
\item{sample.Z.obs}{A vector of effect sizes for each sample.}
\item{sample.Z.var}{A vector of variances for each effect size.}
\item{pairwise.z}{A matrix of pairwise, two-sample z scores between all pairs of effect sizes.}
\item{pairwise.p}{A matrix of corresponding P-values.}
}
\description{
Function performs an analysis to compare the effect sizes of two or more Vrel effects
}
\details{
The function statistically compares the effect sizes of two or more Vrel analyses.  Typically, this
function might be used to compare the strength of integration in one dataset as compared with another 
(see Conaway and Adams 2022). 

The analysis performs two-sample z-tests based on effect sizes (Z-scores) of Vrel. The method 
follows that of Conaway Adams (2022) used to compare the strength of integration across datasets.
 
To use this function, simply perform \code{\link{integration.Vrel}} on as many samples or as desired.  
Any number of objects of class rel.eig can be input. One may perform the comparison as either a 
one-tailed or a two-tailed (default) test.
}
\examples{
 
 data("plethodon")
 Y.gpa <- gpagen(plethodon$land)
 
 coords.gp <- coords.subset(Y.gpa$coords, plethodon$species)
 Vrel.gp <- Map(function(x) integration.Vrel(x), coords.gp) 
 
 out <- compare.ZVrel(Vrel.gp$Jord, Vrel.gp$Teyah)
 
 summary(out)
 
}
\references{
Conaway, M.A., and D.C. Adams. 2022. An effect size for comparing the strength of 
  morphological integration across studies. Evolution. (Accepted).
}
\author{
Dean Adams
}
\keyword{analysis}
