% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-unary-geometry.R
\name{geos_buffer}
\alias{geos_buffer}
\alias{geos_offset_curve}
\alias{geos_buffer_params}
\title{Buffer a geometry}
\usage{
geos_buffer(geom, distance, params = geos_buffer_params())

geos_offset_curve(geom, distance, params = geos_buffer_params())

geos_buffer_params(
  quad_segs = 30,
  end_cap_style = c("round", "flat", "square"),
  join_style = c("round", "mitre", "bevel"),
  mitre_limit = 1,
  single_sided = FALSE
)
}
\arguments{
\item{geom}{A \link[=as_geos_geometry]{GEOS geometry vector}}

\item{distance}{The buffer distance. Can be negative to buffer
or offset on the righthand side of the geometry.}

\item{params}{A \code{\link[=geos_buffer_params]{geos_buffer_params()}}}

\item{quad_segs}{The number of segments per quadrant. A higher number
here will increase the apparent resolution of the resulting polygon.}

\item{end_cap_style}{One of "round", "flat", or "square".}

\item{join_style}{One of "round", "mitre", or "bevel".}

\item{mitre_limit}{If \code{join_style} is "mitre", the relative extent (from zero to one)
of the join.}

\item{single_sided}{Use \code{TRUE} to buffer on only the right side
of the geometry. This does not apply to \code{\link[=geos_offset_curve]{geos_offset_curve()}}, which is always
one-sided.}
}
\value{
A \link[=as_geos_geometry]{GEOS geometry vector} along the recycled
length of \code{geom} and \code{distance}.
}
\description{
\itemize{
\item \code{\link[=geos_buffer]{geos_buffer()}} returns a polygon or multipolygon geometry.
\item \code{\link[=geos_offset_curve]{geos_offset_curve()}} returns a linestring offset to the left by \code{distance}.
}
}
\examples{
geos_buffer("POINT (0 0)", 1)
geos_offset_curve("LINESTRING (0 0, 0 10, 10 0)", 1)

}
