% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSLayer.R, R/GSPublishable.R, R/GSStyle.R
\docType{class}
\name{GSLayer}
\alias{GSLayer}
\alias{GSLayer}
\alias{GSPublishable}
\alias{GSLayer}
\alias{GSStyle}
\title{A GeoServer layer resource}
\format{\code{\link{R6Class}} object.}
\usage{
GSLayer

GSPublishable

GSStyle
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer layer

Object of \code{\link{R6Class}} for modelling a GeoServer layer group publishable

Object of \code{\link{R6Class}} for modelling a GeoServer style
}
\description{
This class models a GeoServer layer. This class is to be
used for published resource (feature type or coverage).

This class models a GeoServer layer. This class is to be
used internally by \pkg{geosapi} for configuring layers or layer groups
within an object of class \code{GSLayerGroup}

This class models a GeoServer style.
}
\details{
Geoserver REST API Resource

Geoserver REST API Publishable

Geoserver REST API Style
}
\section{Methods}{

\describe{
 \item{\code{new(rootName, xml)}}{
   This method is used to instantiate a GSLayer
 }
 \item{\code{decode(xml)}}{
   This method is used to decode a GSLayer from XML
 }
 \item{\code{encode()}}{
   This method is used to encode a GSLayer to XML. Inherited from the
   generic \code{GSRESTResource} encoder
 }
 \item{\code{setName(name)}}{
   Sets the layer name.
 }
 \item{\code{setPath(path)}}{
   Sets the layer path.
 }
 \item{\code{setDefaultStyle(style)}}{
   Sets the default style.
 }
 \item{\code{setStyles(styles)}}{
   Sets a list of optional styles
 }
 \item{\code{addStyle(style)}}{
   Sets an available style. Returns TRUE if set, FALSE otherwise
 }
 \item{\code{delStyle(name)}}{
   Deletes an available. Returns TRUE if deleted, FALSE otherwise
 }
 \item{\code{setEnabled(enabled)}}{
   Sets if the layer is enabled (TRUE) or not (FALSE)
 }
 \item{\code{setQueryable(queryable)}}{
   Sets if the layer is queryable (TRUE) or not (FALSE)
 }
 \item{\code{setAdvertised(advertised)}}{
   Sets if the layer is advertised (TRUE) or not (FALSE)
 }
}


\describe{
 \item{\code{new(rootName, xml)}}{
   This method is used to instantiate a GSPublishable
 }
 \item{\code{decode(xml)}}{
   This method is used to decode a GSPublishable
 }
 \item{\code{encode()}}{
   This method is used to encode a GSPublishable to XML. Inherited from the
   generic \code{GSRESTResource} encoder
 }
 \item{\code{setName(name)}}{
   Sets the publishable name.
 }
 \item{\code{setType(type)}}{
   Sets the publishable type.
 }
}


\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate a GS Style
 }
 \item{\code{decode(xml)}}{
   This method is used to decode a GSStyle from XML
 }
 \item{\code{encode()}}{
   This method is used to encode a GSStyle to XML. Inherited from the
   generic \code{GSRESTResource} encoder
 }
}
}

\examples{
lyr <- GSLayer$new()

publishable <- GSPublishable$new(name = "name", type = "layer")

lyr <- GSStyle$new()

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>

Emmanuel Blondel <emmanuel.blondel1@gmail.com>

Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{coverage}
\keyword{featureType}
\keyword{geoserver}
\keyword{group}
\keyword{layer}
\keyword{publishable}
\keyword{resource}
\keyword{resourcelayer}
\keyword{rest}
\keyword{style}
