% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSWorkspaceSettings.R
\docType{class}
\name{GSWorkspaceSettings}
\alias{GSWorkspaceSettings}
\title{Geoserver REST API Workspace Setting}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer workspace settings
}
\description{
Geoserver REST API Workspace Setting
}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate a \code{GSWorkspaceSettings}. This settings 
   object is required to activate a workspace configuration, using the method
   \code{GSManager$createWorkspaceSettings}. Supported from GeoServer 2.12
 }
 \item{\code{decode(xml)}}{
   This method is used to decode a \code{GSWorkspaceSettings} from XML
 }
 \item{\code{encode()}}{
   This method is used to encode a \code{GSWorkspaceSettings} to XML. 
   Inherited from the generic \code{GSRESTResource} encoder
 }
 \item{\code{setCharset(charset)}}{
   Set charset
 }
 \item{\code{setNumDecimals(numDecimals)}}{
   Set number of decimals
 }
 \item{\code{setOnlineResource(onlineResource)}}{
   Set the online resource
 }
 \item{\code{setVerbose(verbose)}}{
   Set verbose
 }
 \item{\code{setVerboseExceptions(verboseExceptions)}}{
   Set verbose exceptions
 }
 \item{\code{setLocalWorkspaceIncludesPrefix(includesPrefix)}}{
   Set if the Local workspace includes prefix
 }
}
}

\examples{
settings <- GSWorkspaceSettings$new()
settings$setCharset("UTF-8")
settings$setNumDecimals(5)

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\keyword{settings}
\keyword{workspace}
