% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSLayer.R, R/GSStyle.R
\docType{class}
\name{GSLayer}
\alias{GSLayer}
\alias{GSStyle}
\title{A GeoServer layer resource}
\format{
\code{\link{R6Class}} object.

\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer layer

Object of \code{\link{R6Class}} for modelling a GeoServer style
}
\description{
This class models a GeoServer layer. This class is to be
used for published resource (feature type or coverage).

This class models a GeoServer style.
}
\details{
Geoserver REST API Resource

Geoserver REST API Style
}
\examples{
  lyr <- GSLayer$new()

  lyr <- GSStyle$new()

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>

Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{coverage}
\keyword{featureType}
\keyword{geoserver}
\keyword{layer}
\keyword{resource}
\keyword{resourcelayer}
\keyword{rest}
\keyword{style}
\section{Super class}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{GSLayer}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{full}}{full}

\item{\code{name}}{name}

\item{\code{path}}{path}

\item{\code{defaultStyle}}{default style}

\item{\code{styles}}{styles}

\item{\code{enabled}}{enabled}

\item{\code{queryable}}{queryable}

\item{\code{advertised}}{advertised}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{GSLayer$new()}}
\item \href{#method-decode}{\code{GSLayer$decode()}}
\item \href{#method-setName}{\code{GSLayer$setName()}}
\item \href{#method-setPath}{\code{GSLayer$setPath()}}
\item \href{#method-setEnabled}{\code{GSLayer$setEnabled()}}
\item \href{#method-setQueryable}{\code{GSLayer$setQueryable()}}
\item \href{#method-setAdvertised}{\code{GSLayer$setAdvertised()}}
\item \href{#method-setDefaultStyle}{\code{GSLayer$setDefaultStyle()}}
\item \href{#method-setStyles}{\code{GSLayer$setStyles()}}
\item \href{#method-addStyle}{\code{GSLayer$addStyle()}}
\item \href{#method-delStyle}{\code{GSLayer$delStyle()}}
\item \href{#method-clone}{\code{GSLayer$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode">}\href{../../geosapi/html/GSRESTResource.html#method-encode}{\code{geosapi::GSRESTResource$encode()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{GSLayer}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-decode"></a>}}
\if{latex}{\out{\hypertarget{method-decode}{}}}
\subsection{Method \code{decode()}}{
Decodes from XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$decode(xml)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setName"></a>}}
\if{latex}{\out{\hypertarget{method-setName}{}}}
\subsection{Method \code{setName()}}{
Set name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$setName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setPath"></a>}}
\if{latex}{\out{\hypertarget{method-setPath}{}}}
\subsection{Method \code{setPath()}}{
Set path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$setPath(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setEnabled"></a>}}
\if{latex}{\out{\hypertarget{method-setEnabled}{}}}
\subsection{Method \code{setEnabled()}}{
Set enabled
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$setEnabled(enabled)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{enabled}}{enabled}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setQueryable"></a>}}
\if{latex}{\out{\hypertarget{method-setQueryable}{}}}
\subsection{Method \code{setQueryable()}}{
Set queryable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$setQueryable(queryable)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{queryable}}{queryable}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setAdvertised"></a>}}
\if{latex}{\out{\hypertarget{method-setAdvertised}{}}}
\subsection{Method \code{setAdvertised()}}{
Set advertised
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$setAdvertised(advertised)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{advertised}}{advertised}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setDefaultStyle"></a>}}
\if{latex}{\out{\hypertarget{method-setDefaultStyle}{}}}
\subsection{Method \code{setDefaultStyle()}}{
Set default style
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$setDefaultStyle(style)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{object o class \link{GSStyle} or \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setStyles"></a>}}
\if{latex}{\out{\hypertarget{method-setStyles}{}}}
\subsection{Method \code{setStyles()}}{
Set styles
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$setStyles(styles)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{styles}}{styles}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addStyle"></a>}}
\if{latex}{\out{\hypertarget{method-addStyle}{}}}
\subsection{Method \code{addStyle()}}{
Adds style
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$addStyle(style)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{style, object o class \link{GSStyle} or \code{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delStyle"></a>}}
\if{latex}{\out{\hypertarget{method-delStyle}{}}}
\subsection{Method \code{delStyle()}}{
Deletes style
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$delStyle(style)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{style, object o class \link{GSStyle} or \code{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{GSStyle}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{full}}{full}

\item{\code{name}}{name}

\item{\code{filename}}{filename}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{GSStyle$new()}}
\item \href{#method-decode}{\code{GSStyle$decode()}}
\item \href{#method-setName}{\code{GSStyle$setName()}}
\item \href{#method-setFilename}{\code{GSStyle$setFilename()}}
\item \href{#method-clone}{\code{GSStyle$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode">}\href{../../geosapi/html/GSRESTResource.html#method-encode}{\code{geosapi::GSRESTResource$encode()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \link{GSStyle}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyle$new(xml = NULL, name = NULL, filename = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{an object of class \link{XMLInternalNode-class}}

\item{\code{name}}{name}

\item{\code{filename}}{filename}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-decode"></a>}}
\if{latex}{\out{\hypertarget{method-decode}{}}}
\subsection{Method \code{decode()}}{
Decodes from XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyle$decode(xml)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{an object of class \link{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setName"></a>}}
\if{latex}{\out{\hypertarget{method-setName}{}}}
\subsection{Method \code{setName()}}{
set name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyle$setName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setFilename"></a>}}
\if{latex}{\out{\hypertarget{method-setFilename}{}}}
\subsection{Method \code{setFilename()}}{
Set filename
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyle$setFilename(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{filename}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyle$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
