% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSLayerManager.R
\docType{class}
\name{GSLayerManager}
\alias{GSLayerManager}
\title{Geoserver REST API Layer Manager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for managing GeoServer
Layers as results of published feature types or coverages
}
\description{
Geoserver REST API Layer Manager

Geoserver REST API Layer Manager
}
\examples{
\dontrun{
   GSLayerManager$new("http://localhost:8080/geoserver", "admin", "geoserver")
 }

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Layer}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\section{Super class}{
\code{\link[geosapi:GSManager]{geosapi::GSManager}} -> \code{GSLayerManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSLayerManager-getLayers}{\code{GSLayerManager$getLayers()}}
\item \href{#method-GSLayerManager-getLayerNames}{\code{GSLayerManager$getLayerNames()}}
\item \href{#method-GSLayerManager-getLayer}{\code{GSLayerManager$getLayer()}}
\item \href{#method-GSLayerManager-createLayer}{\code{GSLayerManager$createLayer()}}
\item \href{#method-GSLayerManager-updateLayer}{\code{GSLayerManager$updateLayer()}}
\item \href{#method-GSLayerManager-deleteLayer}{\code{GSLayerManager$deleteLayer()}}
\item \href{#method-GSLayerManager-getLayerGroups}{\code{GSLayerManager$getLayerGroups()}}
\item \href{#method-GSLayerManager-getLayerGroupNames}{\code{GSLayerManager$getLayerGroupNames()}}
\item \href{#method-GSLayerManager-getLayerGroup}{\code{GSLayerManager$getLayerGroup()}}
\item \href{#method-GSLayerManager-createLayerGroup}{\code{GSLayerManager$createLayerGroup()}}
\item \href{#method-GSLayerManager-updateLayerGroup}{\code{GSLayerManager$updateLayerGroup()}}
\item \href{#method-GSLayerManager-deleteLayerGroup}{\code{GSLayerManager$deleteLayerGroup()}}
\item \href{#method-GSLayerManager-clone}{\code{GSLayerManager$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="ERROR"><a href='../../geosapi/html/GSManager.html#method-GSManager-ERROR'><code>geosapi::GSManager$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="INFO"><a href='../../geosapi/html/GSManager.html#method-GSManager-INFO'><code>geosapi::GSManager$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="WARN"><a href='../../geosapi/html/GSManager.html#method-GSManager-WARN'><code>geosapi::GSManager$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="connect"><a href='../../geosapi/html/GSManager.html#method-GSManager-connect'><code>geosapi::GSManager$connect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getClassName"><a href='../../geosapi/html/GSManager.html#method-GSManager-getClassName'><code>geosapi::GSManager$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getCoverageStoreManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getCoverageStoreManager'><code>geosapi::GSManager$getCoverageStoreManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getDataStoreManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getDataStoreManager'><code>geosapi::GSManager$getDataStoreManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getNamespaceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getNamespaceManager'><code>geosapi::GSManager$getNamespaceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getServiceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getServiceManager'><code>geosapi::GSManager$getServiceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getStyleManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getStyleManager'><code>geosapi::GSManager$getStyleManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getSystemStatus"><a href='../../geosapi/html/GSManager.html#method-GSManager-getSystemStatus'><code>geosapi::GSManager$getSystemStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getUrl"><a href='../../geosapi/html/GSManager.html#method-GSManager-getUrl'><code>geosapi::GSManager$getUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getWorkspaceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getWorkspaceManager'><code>geosapi::GSManager$getWorkspaceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="initialize"><a href='../../geosapi/html/GSManager.html#method-GSManager-initialize'><code>geosapi::GSManager$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="logger"><a href='../../geosapi/html/GSManager.html#method-GSManager-logger'><code>geosapi::GSManager$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="monitor"><a href='../../geosapi/html/GSManager.html#method-GSManager-monitor'><code>geosapi::GSManager$monitor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="reload"><a href='../../geosapi/html/GSManager.html#method-GSManager-reload'><code>geosapi::GSManager$reload()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerManager-getLayers"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerManager-getLayers}{}}}
\subsection{Method \code{getLayers()}}{
Get the list of layers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$getLayers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \code{list} giving items of class \code{\link{GSLayer}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerManager-getLayerNames"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerManager-getLayerNames}{}}}
\subsection{Method \code{getLayerNames()}}{
Get the list of layer names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$getLayerNames()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a vector of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerManager-getLayer"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerManager-getLayer}{}}}
\subsection{Method \code{getLayer()}}{
Get layer by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$getLayer(lyr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lyr}}{layer name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{GSLayer}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerManager-createLayer"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerManager-createLayer}{}}}
\subsection{Method \code{createLayer()}}{
Creates a new layer given an object of class \code{\link{GSLayer}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$createLayer(layer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer}}{object of class \link{GSLayer}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if created, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerManager-updateLayer"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerManager-updateLayer}{}}}
\subsection{Method \code{updateLayer()}}{
Updates a layer given an object of class \code{\link{GSLayer}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$updateLayer(layer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer}}{object of class \link{GSLayer}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if updated, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerManager-deleteLayer"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerManager-deleteLayer}{}}}
\subsection{Method \code{deleteLayer()}}{
Deletes layer given an object of class \code{\link{GSLayer}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$deleteLayer(lyr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lyr}}{layer name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerManager-getLayerGroups"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerManager-getLayerGroups}{}}}
\subsection{Method \code{getLayerGroups()}}{
Get layer groups
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$getLayerGroups(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name. Optional}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list of objects of class \link{GSLayerGroup}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerManager-getLayerGroupNames"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerManager-getLayerGroupNames}{}}}
\subsection{Method \code{getLayerGroupNames()}}{
Get layer group names
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$getLayerGroupNames(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list of layer group names, as vector of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerManager-getLayerGroup"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerManager-getLayerGroup}{}}}
\subsection{Method \code{getLayerGroup()}}{
Get layer group
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$getLayerGroup(lyr, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lyr}}{lyr}

\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{GSLayerGroup}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerManager-createLayerGroup"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerManager-createLayerGroup}{}}}
\subsection{Method \code{createLayerGroup()}}{
Creates a layer group
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$createLayerGroup(layerGroup, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layerGroup}}{object of class \link{GSLayerGroup}}

\item{\code{ws}}{workspace name. Optional}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if created, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerManager-updateLayerGroup"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerManager-updateLayerGroup}{}}}
\subsection{Method \code{updateLayerGroup()}}{
Updates a layer group
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$updateLayerGroup(layerGroup, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layerGroup}}{object of class \link{GSLayerGroup}}

\item{\code{ws}}{workspace name. Optional}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if updated, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerManager-deleteLayerGroup"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerManager-deleteLayerGroup}{}}}
\subsection{Method \code{deleteLayerGroup()}}{
Deletes a layer group
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$deleteLayerGroup(lyr, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lyr}}{layer group name}

\item{\code{ws}}{workspace name. Optional}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
