# TODO: Add comment
# 
# Author: ecor
###############################################################################

NULL
#'
#' Creates an 'geotop.inpts'  files the keyword and their values of a date.frame like the one returned by \code{\link{declared.geotop.inpts.keywords}}
#' 
#' 
#' 
#' @param df data frame returend by \code{\link{declared.geotop.inpts.keywords}}
#' @param file connetion or file name where to write 'df'
#' @param wpath complere path to \code{file} (optional). Default is \code{NULL}. 
#' @param comment.lines vector of strings to add as comments for each keyword. See the default values in the usage. If it is \code{NULL} the comment lines are omitted. 
#' @param header vector of strings to add as a header. See the default values in the usage. If it is \code{NULL} the header is omitted. 
#' @param ... further arguments for \code{\link{writeLines}}
#' 
#' @export
#' @examples 
#' 
#' library(geotopbricks)
#' 
#' #Simulation working path
#' wpath <- 'http://meteogis.fmach.it/idroclima/panola13_run2xC_test3'
#' df <- declared.geotop.inpts.keywords(wpath=wpath)
#' create.geotop.inpts.keyword(df=df)
#' 
#' 
#' 
#' @seealso \code{\link{writeLines}},\code{\link{declared.geotop.inpts.keywords}}
#' 
#' 






create.geotop.inpts.keyword <- function(df,file='geotop.inpts.copy',wpath=NULL,comment.lines=paste("!",c(""," insert optional comment for the keyword below",""),sep=""),
		header=c("",paste("!",file,"automatically generated by create.geotop.inpts.keyword (\'geotobricks\' CRAN R Paackage)"),"",""),...) {

	condition_wpath <- (!is.null(wpath) & !is.na(wpath) & wpath!=FALSE)
	if (length(condition_wpath)==0)  condition_wpath=FALSE
	if (condition_wpath)  file <- paste(wpath,file,sep="/")
	
	
	df <- df[df$Keyword!="",]
	
	lines <- paste(df$Keyword,"=",df$Value)
	
	if (!is.null(comment.lines)) {
		
		NLINES <- (length(comment.lines)+1)*length(lines)
		
		lines_temp <- lines 
		lines <- rep(c(comment.lines,"KEYWORD"),length(lines_temp))
		lines[lines=="KEYWORD"] <- lines_temp
		
	}
	
	if (!is.null(header)) lines <- c(header,lines)
	
	writeLines(lines,con=file,sep="\n",...)
	
	return(0)
	
}