% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listFromOutput3DTensor.R
\name{listFromOutputSoil3DTensor}
\alias{listFromOutputSoil3DTensor}
\title{Extracts a list of files pointing to  an output 3D Tensor or 2D map respectively}
\usage{
listFromOutputSoil3DTensor(x, when, layers = "SoilLayerThicknesses",
  one.layer = FALSE, suffix = "L\%04dN\%04d.asc", wpath = NULL,
  tz = "A", start_date_key = "InitDateDDMMYYYYhhmm",
  end_date_key = "EndDateDDMMYYYYhhmm", timestep = "OutputSoilMaps",
  use.read.raster.from.url = FALSE, crs = NULL, projfile = "geotop.proj",
  start.from.zero = FALSE, secondary.suffix = NULL, ...)
}
\arguments{
\item{x}{string. GEOtop keyword reletated to the 3D or 2D variable to be imported in R.}

\item{when}{\code{\link{POSIXlt-class}} for date and time on which the variable \code{x} is requested.}

\item{layers}{number of soil layer or geotop keyword for soil layer (e.g. \code{SoilLayerThicknesses} or \code{SoilFile}). Default is  \code{SoilLayerThicknesses}.}

\item{one.layer}{logical value. If \code{TRUE} a \code{\link{RasterLayer-class}} object is imported, otherwise a \code{\link{RasterBrick-class}}object is returened. Default for \code{brickFromOutputSoil3DTensor} is \code{FALSE}}

\item{suffix}{charachter string containing the decimal formatter used by GEOtop in the output file names. Default is "L\%04dN\%04.asc". A simple user is recommended not to modify the value of this argument and use the default value.}

\item{wpath, tz, use.read.raster.from.url}{see \code{\link{get.geotop.inpts.keyword.value}}}

\item{start_date_key, end_date_key}{initial and final detes and times of the GEOtop simulation or alternatively the respective keywords of \code{*.inpts} file (Default)}

\item{timestep}{time step expressed in seconds every which the raster file has been created. It can be a string corresponding to the geotop keyword in the inpts file. Default value is \code{"OutputSoilMaps"}.}

\item{crs, start.from.zero}{see \code{\link{brick.decimal.formatter}}. If \code{crs} is not \code{NULL} (Default) , \code{projfile} is ignored.}

\item{projfile}{name of the \code{*.proj} file containing CRS information. See \code{\link{get.geotop.inpts.keyword.value}}. Default is \code{"geotop.proj"}. If is \code{NULL} or \code{NA} or this file does not exist, it is not searched and read.. In case \code{use.read.raster.from.url} is \code{TRUE} and no \code{NULL} or \code{NA} values are assinged, the \code{*.proj} file is searched.}

\item{secondary.suffix}{String secondary suffix which can be added at the end of the Map file name (optional). Default is \code{NULL} and no secondary suffix is added.}

\item{...}{additional arguments for \code{\link{get.geotop.inpts.keyword.value}} or \code{\link{brickFromOutputSoil3DTensor}}}
}
\description{
Extracts a list of files pointing to  an output 3D Tensor or 2D map respectively
}
\details{
This function is experimental and documentation partially exhaustive. These functions \code{brickFromOutputSoil3DTensor} and \code{rasterFromOutput2DMap} return 3D or 2D \code{\link{Raster-class}} objects respectively. \code{rasterFromOutput2DMap} is a wrapper function of \code{brickFromOutputSoil3DTensor} with the option \code{one.layer==TRUE}.
The functionswork with the following output keywords: 

\code{"SoilTempTensorFile"},

\code{"SoilAveragedTempTensorFile"},

\code{"SoilLiqContentTensorFile"},

\code{"SoilAveragedLiqContentTensorFile"},

\code{"SoilIceContentTensorFile"},

\code{"SoilAveragedIceContentTensorFile"},

\code{"SoilLiqWaterPressTensorFile"},

\code{"SoilTotWaterPressTensorFile"}     for \code{\link{brickFromOutputSoil3DTensor}};


\code{"FirstSoilLayerTempMapFile"}, 
  
\code{"FirstSoilLayerAveragedTempMapFile"},
 
\code{"FirstSoilLayerLiqContentMapFile"},

\code{"FirstSoilLayerIceContentMapFile"}, 
 
\code{"LandSurfaceWaterDepthMapFile"}, 
     
\code{"ChannelSurfaceWaterDepthMapFile"},
   
\code{"NetRadiationMapFile"}, 
              
\code{"InLongwaveRadiationMapFile"}, 
      
\code{"NetLongwaveRadiationMapFile"},
       
\code{"NetShortwaveRadiationMapFile"},
      
\code{"InShortwaveRadiationMapFile"}, 
      
\code{"DirectInShortwaveRadiationMapFile"},


\code{"ShadowFractionTimeMapFile"},

\code{"SurfaceHeatFluxMapFile"},  
          
\code{"SurfaceSensibleHeatFluxMapFile"},

\code{"SurfaceLatentHeatFluxMapFile"}, 
    
\code{"SurfaceTempMapFile"},    
     
\code{"PrecipitationMapFile"},  
            
\code{"CanopyInterceptedWaterMapFile"},
     
\code{"SnowDepthMapFile"},   
              
\code{"GlacierDepthMapFile"}, 
              
\code{"SnowMeltedMapFile"}, 
             
\code{"SnowSublMapFile"}, 
                  
\code{"GlacierMeltedMapFile"}, 
            
\code{"GlacierSublimatedMapFile"},  
        
\code{"AirTempMapFile"},        
            
\code{"WindSpeedMapFile"}, 

\code{"WindDirMapFile"}, 
                  
\code{"RelHumMapFile"}, 
   
\code{"SWEMapFile"},    
   
\code{"GlacierWaterEqMapFile"}  

\code{"SnowDurationMapFile"},
              
\code{"ThawedSoilDepthMapFile"},
            
\code{"ThawedSoilDepthFromAboveMapFile"}, 
  
\code{"WaterTableDepthMapFile"}, 

\code{"WaterTableDepthFromAboveMapFile"},  

\code{"NetPrecipitationMapFile"},

\code{"EvapotranspirationFromSoilMapFile"} for \code{\link{rasterFromOutput2DMap}}.
}
\examples{


tz <-  "Etc/GMT+1"
start <- as.POSIXct("2002-03-22",tz=tz)
end <- as.POSIXct("2002-03-25",tz=tz)
day <- 3600*24
when <- seq(from=start,to=end,by=day)
#' # The data containing in the link are only for educational use
wpath <- "http://www.rendena100.eu/public/geotopbricks/simulations/idroclim_test1"
x <- "SoilLiqContentTensorFile"
when <- as.POSIXct("2002-03-22 UTC",tz="A")

# Not Run because it elapses too long time!!! 
# Please Uncomment the following lines to run by yourself!!!


# wpath <- '/Users/ecor/attivita/2013/fem-idroclima/Trentino_500_dstr_GEOtop_1_225_9_002'

#kpsi <- "SoilLiqWaterPressTensorFile" ## soil water pressure head 

out <-listFromOutputSoil3DTensor(x,when=when,wpath=wpath,tz=tz,use.read.raster.from.url=FALSE)
}
\author{
Emanuele Cordano
}
\seealso{
\code{\link{get.geotop.inpts.keyword.value}},\code{\link{brick.decimal.formatter}},\code{\link{brickFromOutputSoil3DTensor}}
}

