% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calCost.R
\name{Transition_Zone_Far_Boundary}
\alias{Transition_Zone_Far_Boundary}
\title{Transition_Zone_Far_Boundary}
\usage{
Transition_Zone_Far_Boundary(map, Z, numZ)
}
\arguments{
\item{map}{object returned by function genMap}

\item{Z}{list of zones.}

\item{numZ}{number of the zone whose values will be approximated.}
}
\value{
approximated values of the zone (numZ) given as parameter.
}
\description{
Transition_Zone_Far_Boundary
}
\details{
funtion that approximates the value in a transition zone (which doesn't have commun boundary with the map)
by the solution of the Laplace's equation. The numerical resolution of the Laplace's equation will be based on the discretisation
of the data on the grid (map$krigGrid).
}
\examples{
\donttest{
 seed=35
 map=genMap(DataObj=NULL,seed=seed,krig=2,typeMod="Exp",nPoints=500)
 ZK=initialZoning(qProb=c(0.65,0.8),map)
 Z=ZK$resZ$zonePolygone # list of zones
 lab = ZK$resZ$lab # label of zones
 plotM(map = map,Z = Z,lab = lab, byLab = FALSE)
 # zone 5 is a transition zone that is far from map boundary
 numZ = 5
 Estimation = Transition_Zone_Far_Boundary(map = map, Z = Z, numZ = numZ)
 # compute the cost
 cL = Cost_By_Laplace(map = map, Z = Z, numZ = numZ, Estimation = Estimation)
 cM = Cost_By_Mean(map = map, Z = Z, numZ = numZ)
 print(cL$cost_Laplace)
 print(cM$cost_Mean)
 # zone 5 is a zone with gradient
}
}
