% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothingZone.R
\name{cal.max.width.Zone}
\alias{cal.max.width.Zone}
\title{cal.max.width.Zone}
\usage{
cal.max.width.Zone(z, step = 0.001, widthMax = 0.05, boundary,
  erosion = TRUE)
}
\arguments{
\item{z}{spatial polygon}

\item{step}{the difference between 2 values of parameter width in the function gBuffer}

\item{widthMax}{the maximum value of the parameter width in gBuffer}

\item{boundary}{union of all zones of the corrected map (result of correctBoundaryMap())}

\item{erosion}{logical, if TRUE, compute the maximum value of width in case erosion->dilatation, otherwise in case dilatation->erosion}
}
\value{
maximum value of parameter width in the function smoothingZone
}
\description{
cal.max.width.Zone
}
\details{
function that return the maximal value of the parameter "width" in function gBuffer in order not to make zone disappear
or not to split a zone into 2 differents zones
}
\examples{
\donttest{
seed=1
map=genMap(DataObj=NULL,seed=seed,disp=FALSE,krig=2,typeMod="Gau")
criti = correctionTree(qProb = c(0.4,0.6), map = map)
Z = criti$zk[[2]][[1]]$zonePolygone
lab = criti$zk[[2]][[1]]$lab
# zones' correction
res = correctBoundaryMap(Zi = Z, map = map)
Z = res$Z
# map boundary after correction
boundary = Z[[1]]
for(i in 2:length(Z)){
   boundary = rgeos::gUnion(boundary, Z[[i]])
}
# plot map
plotM(map = map, Z = Z, lab = lab, byLab = FALSE)
widthMax = cal.max.width.Zone(z = Z[[3]], step = 0.001,
            widthMax = 0.05, boundary = boundary, erosion = TRUE)
zone = zone.extended(z = Z[[3]], boundary = boundary)
erosion1 = rgeos::gBuffer(zone ,width = - (widthMax + 0.002) ,joinStyle="ROUND",capStyle = "ROUND")
erosion2 = rgeos::gBuffer(zone ,width = - (widthMax - 0.002) ,joinStyle="ROUND",capStyle = "ROUND")
rgeos::plot(erosion1)
rgeos::plot(erosion2)
}
}
