% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calCost.R
\name{list_Zone_2_Neighbours}
\alias{list_Zone_2_Neighbours}
\title{list_Zone_2_Neighbours}
\usage{
list_Zone_2_Neighbours(Z, lab)
}
\arguments{
\item{Z}{list of Zones}

\item{lab}{vector labels of zones}
}
\value{
a vector containing zone numbers
}
\description{
list_Zone_2_Neighbours
}
\details{
Returns the numbers of zones that have exactly 2 neighbours with different labels. These zone are susceptible to be
transitions zones
}
\examples{
\donttest{
 seed=20
 map=genMap(DataObj=NULL,seed=seed,krig=2,typeMod="Exp")
 ZK=initialZoning(qProb=c(0.67,0.8),map)
 Z=ZK$resZ$zonePolygone # list of zones
 lab = ZK$resZ$lab # label of zones
 plotM(map = map,Z = Z,lab = lab, byLab = FALSE)
 # zone 5 and 11 are transition zones and have exactly 2 neighbours with different labels.
 list_Zone_2_Neighbours(Z = Z, lab = lab)
}
}
