% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilZ.R
\name{trLabZone}
\alias{trLabZone}
\title{trLabZone}
\usage{
trLabZone(K1, K2, map, qProb, disp = 0)
}
\arguments{
\item{K1}{zoning object (such as returned by calNei function)}

\item{K2}{zoning object (such as returned by calNei function)}

\item{map}{object returned by genMap function}

\item{qProb}{probability vector used to generate quantile values}

\item{disp}{0: no info, 1: detailed info}
}
\value{
a zoning object
}
\description{
trLabZone
}
\details{
transfer zone labels from K1 to K2
}
\examples{
\donttest{
data(mapTest)
data(resZTest)
K=resZTest
Ns=geozoning:::getNs(K$zoneNModif,5) # find neighbors of zone 5
zf=zoneFusion3(K,5,Ns,mapTest,disp=0) # merge zone 5 with englobing one
K2=calNei(zf,mapTest$krigData,mapTest$krigSurfVoronoi,mapTest$krigN)
K2=geozoning:::trLabZone(K,K2,mapTest,K$qProb)
}
}
\keyword{internal}
