% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeanGermPercent.R
\name{MeanGermPercent}
\alias{MeanGermPercent}
\alias{MeanGermNumber}
\title{Mean germination percentage and number of seeds per time interval}
\usage{
MeanGermPercent(
  germinated.seeds,
  germ.counts,
  total.seeds,
  intervals,
  partial = TRUE
)

MeanGermNumber(germ.counts, intervals, partial = TRUE)
}
\arguments{
\item{germinated.seeds}{Number of germinated seeds}

\item{germ.counts}{Germination counts at each time interval. Can be partial
or cumulative as specified in the argument \code{partial}.}

\item{total.seeds}{Total number of seeds.}

\item{intervals}{The time intervals.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}
}
\value{
The value of mean germination percentage or mean number of seeds per
  time interval.
}
\description{
Compute the following metrics:\describe{ \item{\code{MeanGermPercent}}{
Mean/average germination percentage per unit time (\mjseqn{\overline{GP}})
\insertCite{czabator_germination_1962}{germinationmetrics}. }
\item{\code{MeanGermNumber}}{Number of seeds germinated per unit time
(\mjseqn{\overline{N}})
\insertCite{khamassi_optimal_2013}{germinationmetrics}.}} \loadmathjax
}
\details{
Mean germination percentage per unit time (\mjseqn{\overline{GP}}) is
computed as follows
\insertCite{czabator_germination_1962}{germinationmetrics}.

\mjsdeqn{\overline{GP} = \frac{GP}{T_{k}}}

Where, \mjseqn{GP} is the final germination percentage, \mjseqn{T_{k}} is the
time at the \mjseqn{k}th time interval, and \mjseqn{k} is the total number of
time intervals required for final germination.

Mean number of seeds germinated per unit time (\mjseqn{\overline{N}}) is
computed as follows \insertCite{khamassi_optimal_2013}{germinationmetrics}.

\mjsdeqn{\overline{N} = \frac{N_{g}}{T_{k}}}

Where, \mjseqn{N_{g}} is the number of germinated seeds at the end of the
germination test, \mjseqn{T_{k}} is the time at the \mjseqn{k}th time
interval, and \mjseqn{k} is the total number of time intervals required for
final germination.
}
\examples{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)

# From partial germination counts
#----------------------------------------------------------------------------
MeanGermPercent(germ.counts = x, total.seeds = 50, intervals = int)
MeanGermNumber(germ.counts = x, intervals = int)

# From cumulative germination counts
#----------------------------------------------------------------------------
MeanGermPercent(germ.counts = y, total.seeds = 50, intervals = int, partial = FALSE)
MeanGermNumber(germ.counts = y, intervals = int, partial = FALSE)

# From number of germinated seeds
#----------------------------------------------------------------------------
MeanGermPercent(germinated.seeds = 40, total.seeds = 50, intervals = int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[germinationmetrics]{GermPercent}}
}
