% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FourPHFfit.bulk.R
\name{FourPHFfit.bulk}
\alias{FourPHFfit.bulk}
\title{Fit four-parameter hill function for multiple samples}
\usage{
FourPHFfit.bulk(
  data,
  total.seeds.col,
  counts.intervals.cols,
  intervals,
  partial = TRUE,
  fix.y0 = TRUE,
  fix.a = TRUE,
  tmax,
  xp = c(10, 60),
  umin = 10,
  umax = 90,
  tries = 3
)
}
\arguments{
\item{data}{A data frame with the germination count data. It should possess
columns with \itemize{ \item Partial or cumulative germination counts per
time interval (to be indicated by the argument \code{counts.intervals.cols}
and \item Total number of seeds tested (to be indicated by the argument
\code{total.seeds.col}). }}

\item{total.seeds.col}{The name of the column in \code{data} with the total
number of seeds tested.}

\item{counts.intervals.cols}{The names of columns in \code{data} with the
germination counts (partial or cumulative, as indicated by the argument
\code{partial}) per time interval (indicated by the argument
\code{intervals}).}

\item{intervals}{The time intervals.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}

\item{fix.y0}{Force the intercept of the y axis through 0.}

\item{fix.a}{Fix a as the actual maximum germination percentage at the end of
the experiment.}

\item{tmax}{The time up to which AUC is to be computed.}

\item{xp}{Germination percentage value(s) for which the corresponding time is
to be computed as a numeric vector. Default is \code{c(10, 60)}.}

\item{umin}{The minimum germination percentage value for computing
uniformity. Default is \code{10}. Seed \strong{\code{Details}}.}

\item{umax}{The maximum germination percentage value for computing
uniformity. Default is \code{90}. Seed \strong{\code{Details}}.}

\item{tries}{The number of tries to be attempted to fit the curve. Default is
3.}
}
\value{
A data frame with the original data along with the various parameters
  of the respective fitted four-parameter hill function.
}
\description{
Fit four-parameter hill function from a data frame of germination counts
recorded at specific time intervals for multiple samples in batch.
}
\examples{

\donttest{
data(gcdata)

counts.per.intervals <- c("Day01", "Day02", "Day03", "Day04", "Day05",
                          "Day06", "Day07", "Day08", "Day09", "Day10",
                          "Day11", "Day12", "Day13", "Day14")

FourPHFfit.bulk(gcdata, total.seeds.col = "Total Seeds",
                    counts.intervals.cols = counts.per.intervals,
                    intervals = 1:14, partial = TRUE,
                    fix.y0 = TRUE, fix.a = TRUE, xp = c(10, 60),
                    tmax = 20, tries = 3, umax = 90, umin = 10)
}

}
\references{
\insertRef{el-kassaby_seed_2008}{germinationmetrics}
}
\seealso{
This function is a wrapper around the
  \code{\link[germinationmetrics]{FourPHFfit}} function for fitting
  four-parameter hill curve.
}
