% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gestcat.R
\name{gestcat}
\alias{gestcat}
\title{G-Estimation for an End of Study Outcome and Categorical Exposure Variable}
\usage{
gestcat(
  data,
  idvar,
  timevar,
  Yn,
  An,
  Ybin,
  Lny,
  Lnp,
  type = 1,
  Cn = NA,
  LnC = NA,
  ...
)
}
\arguments{
\item{data}{A data frame in long format containing the data to be analysed. See description for details.}

\item{idvar}{Character string specifying the name of the ID variable in data.}

\item{timevar}{Character string specifying the name of the time variable in the data.
Note that timevar must specify time periods as integer values starting from 1 (must not begin at 0).}

\item{Yn}{Character string specifying the name of the end of study outcome variable.}

\item{An}{Character string specifying the name of the time-varying exposure variable.}

\item{Ybin}{TRUE or FALSE indicator of whether the outcome is binary.}

\item{Lny}{Vector of character strings specifying the names of the
variables to be included in the outcome model in quotations.}

\item{Lnp}{Vector of character strings specifying the names of the variables
to be included in the model calculating the propensity scores.}

\item{type}{Value from 1-4 specifying SNMM type to fit. See details.}

\item{Cn}{Optional character string specifying the name of the censoring indicator variable.
The variable specified in Cn should be a numeric vector taking values 0 or 1, with 1 indicating censored.}

\item{LnC}{Vector of character strings specifying the names of the variables to be used in the censoring score model to calculate
the censoring weights. Note that any variable in \code{LnC} should also be in \code{Lnp} for the validity of the censoring and propensity weights.}

\item{...}{Additional arguments, currently not in use.}
}
\value{
List of the fitted causal parameters of the posited SNMM. These are labeled as follows for each SNMM type, where An is
set to the name of the exposure variable, i is the current time period, j is the category level, and Lny[1] is set to the name of the first confounder in \code{Lny}.
\item{\code{type=1} }{Anj: The effect of exposure at category j at any time t on outcome. }
\item{\code{type=2} }{Anj: The effect of exposure at category j, at any time t on outcome, when Ln[1] is set to zero.\cr
Anj:Ln[1]: The effect modification by Lny[1], the additional effect of A at category j on Y for each unit increase in Lny[1]. }
\item{\code{type=3} }{t=i.Anj: The effect of exposure at category j, at time t=i on outcome.}
\item{\code{type=4} }{t=i.Anj: The effect of exposure at category j, at time t=i on outcome when Ln[1] is set to zero.\cr
t=i.Anj:Ln[1]: The effect modification by Lny[1], the additional effect of A at category j at time t=i on Y, for each unit increase in Lny[1].}
}
\description{
Performs g-estimation of a structural nested mean model (SNMM), based on the outcome regression methods described
in Sjolander and Vansteelandt (2016) and Dukes and Vansteelandt (2018). We expect a dataset with an end of study outcome that is either binary or continuous,
time-varying and/or baseline confounders, and a categorical time-varying exposure of two of more categories.
}
\details{
Suppose a set of time varying confounders \eqn{L_t}, and a time-varying categorical exposure variable \eqn{A_t}, measured over time periods \eqn{t=1,\ldots,T}, with an end of study outcome \eqn{Y} measured at time \eqn{T+1}.
Also suppose that \eqn{A_t} holds data consisting of \eqn{k\geq 2} categories. These categories may take any arbitrary list of names, but we assume for theory purposes they are labeled as \eqn{j=0,1\ldots,k},
where \eqn{j=0} denotes no exposure, or some reference category. Define binary variables \eqn{A_t^j} \eqn{j=0,1,\ldots,k} where \eqn{A_t^j=1} if \eqn{A_t=j} and 0 otherwise.
Then \code{gestcat} fits a SNMM of the form
 \deqn{E(Y(\bar{a}_{t},a^0)-Y(\bar{a}_{t-1},a^0)|\bar{a}_{t-1},\bar{l}_{t})=\sum_{j=1}^{k}\psi^j z_ta^j_{t} \;\forall\; t=1,\ldots,T}
 if Y is continuous or
 \deqn{\frac{E(Y(\bar{a}_{t},a^0)|\bar{a}_{t-1},\bar{l}_{t})}{E(Y(\bar{a}_{t-1},a^0)|\bar{a}_{t-1},\bar{l}_{t})}=exp(\sum_{j=1}^{k}\psi^j z_ta^j_{t})\;\forall\; t=1,\ldots,T }
 if Y is binary. The SNNM fits a separate set of causal parameters \eqn{\psi^j}, for the effect of exposure at category \eqn{j} on outcome,
 compared to exposure at the reference category 0, for each non-reference category. The models form is defined by the parameter \eqn{z_t}, which can be controlled by the input \code{type} as follows
 \itemize{
 \item{\code{type=1} }{sets \eqn{z_t=1}. This implies that \eqn{\psi^j} is now the effect of exposure when set to category \eqn{j}, (compared the reference category) at any time t on Y.}
 \item{\code{type=2} }{sets \eqn{z_t=c(1,l_t)}, and adds affect modification by the first named variable in \code{Lny}, which we denote \eqn{L_t}.
 Now \eqn{\psi^j=c(\psi^j_0,\psi^j_1)} where \eqn{\psi^j_0} is the effect of exposure when set to category \eqn{j}, (compared the reference category) at any time t on Y when \eqn{l_t=0} for all t, modified by
 \eqn{\psi^j_1} for each unit increase in \eqn{l_t} for all t. Note that effect modification
 is currently only supported for binary or continuous confounders.}
 \item {\code{type=3} }{sets \eqn{z_t} to a vector of zeros of length T with a 1 in the t'th position. Now \eqn{\psi^j=c(\psi^j_1,\ldots,\psi^j_T)}
 where \eqn{\psi^j_t} is the effect of exposure, when set to category \eqn{j}, at time t on Y.}
 \item{\code{type=4} }{allows for a time-varying causal effect that can be modified by the first named variable in \code{Lny}, that is it allows for both time-varying effects and effect modification. It sets \eqn{z_t} to a vector of zeros of length T with \eqn{c(1,l_t)} in the t'th position.
 Now \eqn{\psi^j=(\underline{\psi^j_1},\ldots,\underline{\psi^j_T})} where \eqn{\underline{\psi^j_t}=c(\psi^j_{0t},\psi^j_{1t})}. Here \eqn{\psi^j_{0t}} is the effect of exposure when set to category \eqn{j} at time t on Y at \eqn{l_t=0}, modified by
 \eqn{\psi^j_{1t}} for each unit increase in \eqn{l_t}. Note that effect modification
 is currently only supported for binary or continuous confounders. }
 }
 The data must be in long format, where we assume the convention that each row with \code{time=t} contains \eqn{A_t,L_t} and \eqn{C_{t+1}} and \eqn{Y_{T+1}}. That is the censoring indicator for each row
 should indicate that a user is censored AFTER time t. The end of study outcome \eqn{Y_{T+1}} should be repeated on each row. If Y is binary, it must be written as a numeric vector taking values either 0 or 1.
 The same is true for any covariate that is used for effect modification.\cr
 The data must be rectangular with a row entry for every individual for each exposure time 1 up to T. Data rows after censoring should be empty apart from the ID and time variables. This can be done using the function \code{\link{FormatData}}.\cr
 By default the censoring, propensity and outcome models include the exposure history at the previous time as an explanatory variable. One may consider also including all previous exposure and confounder history as variables in \code{Lny},\code{Lnp}, and \code{LnC} if necessary.\cr
 Censoring weights are handled as described in Sjolander and Vansteelandt (2016). Note that it is necessary that any variable included in \code{LnC} must also be in \code{Lnp}. Missing data not due to censoring are handled automatically by removing rows with missing data prior to fitting the model. If outcome models fail to fit, consider removing covariates from \code{Lny} but keeping
 them in \code{Lnp} to reduce collinearity issues, or consider the sparseness of the data.
}
\examples{
datas<-dataexamples(n=1000,seed=123,Censoring=FALSE)
data=datas$datagestcat
#A is a categorical variable with categories labeled 1,2 and 3, with 1 the
#reference category
idvar="id"
timevar="time"
Yn="Y"
An="A"
Ybin=FALSE
Lny=c("L","U")
Lnp=c("L","U")
Cn<-NA
LnC<-NA
type=NA

gestcat(data,idvar,timevar,Yn,An,Ybin,Lny,Lnp,type=1)

#Example with censoring
datas<-dataexamples(n=1000,seed=123,Censoring=TRUE)
data=datas$datagestcat
Cn="C"
LnC=c("L","U")
gestcat(data,idvar,timevar,Yn,An,Ybin,Lny,Lnp,type=3,Cn,LnC)

}
\references{
Vansteelandt, S., & Sjolander, A. (2016). Revisiting g-estimation of the Effect of a Time-varying Exposure Subject to Time-varying Confounding, Epidemiologic Methods, 5(1), 37-56. <doi:10.1515/em-2015-0005>.

Dukes, O., & Vansteelandt, S. (2018). A Note on g-Estimation of Causal Risk Ratios, American Journal of Epidemiology, 187(5), 1079–1084. <doi:10.1093/aje/kwx347>.
}
