% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_who.R
\name{scale_colour_who}
\alias{scale_colour_who}
\alias{scale_color_who}
\title{Adds World Health Organization-inspired colours to plots}
\usage{
scale_colour_who(
  palette = "main",
  discrete = TRUE,
  reverse = FALSE,
  n = NULL,
  add_missings = FALSE,
  ...
)
}
\arguments{
\item{palette}{A character string. the colours of choice, current options are
"main", "light" and "misc" for mixed colours as well as "purple", "turquoise",
"blue", "magenta", "brown", "misc", "green", and "red".}

\item{discrete}{Logical, defaults to \code{TRUE}. Should the palette be discrete or continuous.}

\item{reverse}{Logical, defaults to \code{FALSE}. Should the palette be reversed.}

\item{n}{Number of colours desired. If a specific value is given which corresponds
to the length of a palette used in the 2019 WHO TB report, this palette is returned,
else the number of entries in the palette with the most colour options (up to its
full length) is returned. Defaults to \code{NULL} which returns the longest palette.}

\item{add_missings}{Add a grey and white colour to the palette, defaults to \code{FALSE}.}

\item{...}{Pass additional arguments to \code{ggplot2::discrete_scale} or \code{ggplot2::scale_colour_viridis_c}
depending on the \code{discrete} setting.
@param ... Pass additional arguments to \code{ggplot2::discrete_scale} or \code{ggplot2::scale_colour_viridis_c}
depending on the \code{discrete} setting.}
}
\description{
Applies WHO inspired colours for \code{ggplot2} plots. Currently a continuous
palette has not been implemented so the \code{viridis} palettes will be used as a fallback in this situation.
}
\examples{

plot_tb_burden_summary(
  countries = "United Kingdom", compare_all_regions = FALSE,
  compare_to_region = TRUE, conf = NULL, verbose = FALSE
) +
  theme_who() +
  scale_colour_who(reverse = TRUE)
}
\seealso{
scale_colour_who scale_fill_who who_palettes
}
\author{
Maria Bekker-Nielsen Dunbar

Sam Abbott
}
