% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_gfc_tiles.R
\name{calc_gfc_tiles}
\alias{calc_gfc_tiles}
\title{Calculate the GFC product tiles needed for a given AOI}
\usage{
calc_gfc_tiles(aoi)
}
\arguments{
\item{aoi}{an Area of Interest (AOI) as a \code{SpatialPolygons*} or \code{sf} object.
If the AOI is not in the WGS84 geographic coordinate system, it will be 
reprojected to WGS84.}
}
\value{
a \code{SpatialPolygonsDataFrame} of the GFC tiles needed to cover 
the AOI
}
\description{
Intersects an AOI with the GFC 
product grid to determine what tiles are need to cover the AOI.
}
\examples{
tiles <- calc_gfc_tiles(test_poly)
plot(tiles)
plot(test_poly, lt=2, add=TRUE)
}
