% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstatscn.R
\name{statscnQueryData}
\alias{statscnQueryData}
\title{query data in the statscn db}
\usage{
statscnQueryData(zb = "A0201", dbcode = "hgnd", rowcode = "zb",
  colcode = "sj", moreWd = list(name = NA, value = NA))
}
\arguments{
\item{zb}{the zb/category code to be queried}

\item{dbcode}{the db code for querying}

\item{rowcode}{rowcode in the returned data frame}

\item{colcode}{colcode in the returned data frame}

\item{moreWd}{more constraint on the data
where the name should be one of c("reg","sj") , which stand for region and sj/time.
the valuecode for reg should be the region code queried by statscnRegions()
the valuecode for sj should be like '2014' for *nd , '2014C' for *jd , '201405' for *yd.
Be noted that , the moreWd name should be different with either rowcode or colcode}
}
\value{
the data frame you are quering
}
\description{
the main function for querying the statscn database, it will retrieve the data from specified db and orginize the data in a data frame.
}
\examples{

\dontrun{
df <- statscnQueryData('A0201', dbcode = 'hgnd')
df <- statscnQueryData('A0201',dbcode = 'fsnd', rowcode = 'zb', colcode = 'sj',
                    moreWd = list(name = 'reg', value = '110000'))
}


}
\references{
Xuehui YANG (2016). rstatscn: R Interface for China National Data. R
package version 1.1.1. https://CRAN.R-project.org/package=rstatscn
}
