% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{gfiCDF}
\alias{gfiCDF}
\title{Fiducial cumulative distribution function}
\usage{
gfiCDF(parameter, fidsamples)
}
\arguments{
\item{parameter}{a right-sided formula defining the parameter of interest}

\item{fidsamples}{fiducial samples, the output of \code{\link{gfilogisreg}}}
}
\value{
The fiducial cumulative distribution function of the parameter.
}
\description{
Fiducial cumulative distribution function of a parameter of
  interest.
}
\examples{
y <- c(
  0, 0, 0, 1,
  0, 1, 1, 1
)
group <- gl(2, 4)
fidsamples <- gfilogisreg(y ~ 0 + group, N = 500) # (N=500 is not serious)
fcdf <- gfiCDF(~ exp(group1) / exp(group2), fidsamples)
fcdf(1)
plot(fcdf)
}
