% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interventions.R
\name{threshold}
\alias{threshold}
\title{Threshold Intervention}
\usage{
threshold(newdf, pool, intvar, intvals, time_name, t)
}
\arguments{
\item{newdf}{Data table containing the simulated data at time \eqn{t}.}

\item{pool}{Data table containing the simulated data at times before \eqn{t}.}

\item{intvar}{Character string specifying the name of the variable to be intervened on in each round of the simulation.}

\item{intvals}{A list of length 2. The first entry is lower bound of the threshold, and the second entry is the upper bound.}

\item{time_name}{Character string specifying the name of the time variable in \code{pool} and \code{newdf}.}

\item{t}{Integer specifying the current time index.}
}
\value{
No value is returned. The data table \code{newdf} is modified in place.
}
\description{
This function implements a threshold intervention (i.e., once treatment bypasses a certain
threshold, it remains at that threshold until end of follow-up) for the specified
intervention variable in the data table \code{newdf}.
}
\examples{

## Estimating the effect of threshold interventions on the mean of a binary
## end of follow-up outcome
\donttest{
id <- 'id_num'
time_name <- 'time'
covnames <- c('cov1', 'cov2', 'treat')
outcome_name <- 'outcome'
histories <- c(lagged, cumavg)
histvars <- list(c('treat', 'cov1', 'cov2'), c('cov1', 'cov2'))
covtypes <- c('binary', 'zero-inflated normal', 'normal')
covparams <- list(covmodels = c(cov1 ~ lag1_treat + lag1_cov1 + lag1_cov2 + cov3 +
                                  time,
                                cov2 ~ lag1_treat + cov1 + lag1_cov1 + lag1_cov2 +
                                  cov3 + time,
                                treat ~ lag1_treat + cumavg_cov1 +
                                  cumavg_cov2 + cov3 + time))
ymodel <- outcome ~  treat + cov1 + cov2 + lag1_cov1 + lag1_cov2 + cov3
intvars <- list('treat', 'treat')
interventions <- list(list(c(static, rep(0, 7))),
                      list(c(threshold, 1, Inf)))
int_descript <- c('Never treat', 'Threshold - lower bound 1')
nsimul <- 10000
ncores <- 2

gform_bin_eof <- gformula_binary_eof(obs_data = binary_eofdata, id = id,
                                     time_name = time_name,
                                     covnames = covnames,
                                     outcome_name = outcome_name,
                                     covtypes = covtypes,
                                     covparams = covparams,
                                     ymodel = ymodel,
                                     intvars = intvars,
                                     interventions = interventions,
                                     int_descript = int_descript,
                                     histories = histories, histvars = histvars,
                                     basecovs = c("cov3"), seed = 1234,
                                     parallel = TRUE, nsamples = 5,
                                     nsimul = nsimul, ncores = ncores)
gform_bin_eof
}

}
