% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lw.R
\name{plot_lw}
\alias{plot_lw}
\title{Plot length-weight relationships}
\usage{
plot_lw(
  dt,
  length = "length",
  weight = "weight",
  sex = "sex",
  female.sex = "F",
  male.sex = "M",
  length.unit = "cm",
  weight.unit = "kg",
  split.by.sex = FALSE,
  xlab = "Total length",
  ylab = "Weight",
  use.nls = FALSE,
  init.a = NULL,
  init.b = NULL,
  log.axes = FALSE,
  base_size = 8,
  legend.position = "bottom",
  correct.units = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{dt}{A data.frame, tibble or data.table}

\item{length}{Character argument giving the name of the length column in \code{dt}}

\item{weight}{Character argument giving the name of the age column in \code{dt}}

\item{sex}{Character argument giving the name of the sex column in \code{dt}. Ignored if \code{split.by.sex == FALSE}.}

\item{female.sex}{A character denoting female sex in the \code{sex} column of \code{dt}}

\item{male.sex}{A character denoting male sex in the \code{sex} column of \code{dt}}

\item{length.unit}{Character argument giving the unit of \code{length}. Will be used in the labels of the figure and for conversion of the a parameter. Allowed values for the conversion: "mm" (millimmeters), "cm" (centimeters), and "m" (meters).}

\item{weight.unit}{Character argument giving the unit of \code{weight}. Will be used in the labels of the figure and for conversion of the a parameter. Allowed values: "g" (grams), "kg" (kilograms), and "t" (metric tons).}

\item{split.by.sex}{Logical indicating whether the result should be split by sex.}

\item{xlab}{Character giving the x-axis label without unit}

\item{ylab}{Character giving the x-axis label without unit.}

\item{use.nls}{Logical indicating whether the parameters should be calculated using the nonlinear least squares (\code{nls; TRUE}) method over the log-log transformed linear model (\code{lm; FALSE}) method.}

\item{init.a, init.b}{Numeric values giving the starting value for a and b parameters respecitively for non-linear least-squares estimation (i.e. when \code{use.nls = TRUE}). If \code{NULL}, default values are guessed.}

\item{log.axes}{Logical indicating whether logarithmic axes should be used instead of cartesian ones.}

\item{base_size}{Base size parameter for ggplot. See \link[ggplot2]{ggtheme}.}

\item{legend.position}{Position of the ggplot legend as a character. See \link[ggplot2]{ggtheme}.}

\item{correct.units}{Logical indicating whether a and b parameters should be converted for centimeters and grams as in FishBase.}

\item{verbose}{Logical indicating whether to return warnings and messages.}
}
\value{
A ggplot together with the a and b parameters.
}
\description{
Plot length-weight relationships
}
\details{
It is crucial to get the units right when calculating length-weight relationships. In models, the length and weight units should often match those of the data going into the model, while in comparisons with FishBase, the units of length and weight should be centimetres and grams, respectively. If the units are wrong, the intercept, a, will be off the FishBase scale by orders of magnitude (see \href{https://www.fishbase.se/manual/english/FishBaseThe_LENGTH_WEIGHT_Table.htm}{FishBase}). If \code{correct.units = TRUE}, \code{plot_lw()} attempts to correct for the units to the FishBase standard (cm and g). The function also returns a warning when the returned parameters are not within expected bounds for cm and g estimation. You can ignore this warning if you want to estimate values. Comparing your a and b with those in FishBase for the species is a good idea. This function may contain bugs.
}
\examples{
data(survey_ghl)

# Simple plot
plot_lw(survey_ghl, length = "length", weight = "weight")
\donttest{
# Split by sex
plot_lw(survey_ghl, split.by.sex = TRUE)$plot
}
}
\author{
Mikko Vihtakari // Institute of Marine Research.
}
