% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_pts.R
\name{quantile_pts}
\alias{quantile_pts}
\title{Find points evenly distributed along the vectors values.}
\usage{
quantile_pts(object, groups, intervals = FALSE)
}
\arguments{
\item{object}{vector object of values.}

\item{groups}{how many points do we want}

\item{intervals}{should we return the raw points or intervals to 
be passed to the \code{cut} function}
}
\value{
vector of groups+1 cut point values.
}
\description{
This function finds point values from a vector argument to produce
 \code{groups} intervals. Setting \code{groups=2} will return three values, 
 the two end points, and one mid point (at the median value of the vector). 

The output can be passed directly into the breaks argument of the
\code{cut} function for creating groups for coplots.
}
\examples{
\dontrun{
data(rfsrc_Boston)

# To create 6 intervals, we want 7 points. 
# quantile_pts will find balanced intervals 
rm_pts <- quantile_pts(rfsrc_Boston$xvar$rm, groups=6, intervals=TRUE)

# Use cut to create the intervals
rm_grp <- cut(rfsrc_Boston$xvar$rm, breaks=rm_pts)

summary(rm_grp)
}
}
\seealso{
\code{cut} \code{\link{gg_partial_coplot}}
}

