% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-stack-.R
\name{stack_align}
\alias{stack_align}
\alias{stack_alignv}
\alias{stack_alignh}
\alias{stack_free}
\alias{stack_freev}
\alias{stack_freeh}
\title{Arrange Plots Horizontally or Vertically}
\usage{
stack_align(data = NULL, direction = NULL, ..., theme = NULL, sizes = NA)

stack_alignv(data = NULL, ...)

stack_alignh(data = NULL, ...)

stack_free(data = NULL, direction = NULL, ..., theme = NULL, sizes = NA)

stack_freev(data = NULL, ...)

stack_freeh(data = NULL, ...)
}
\arguments{
\item{data}{Default dataset to use for the layout. If not specified, it must be supplied in each plot added to the layout. By default, it will try to inherit from parent layout:
\itemize{
\item For \code{stack_free}, \code{\link[=fortify_data_frame]{fortify_data_frame()}} will be used to convert data to
a data frame.
\item For \code{stack_align}, \code{\link[=fortify_matrix]{fortify_matrix()}} will be used to convert data to a
matrix.
}}

\item{direction}{A string indicating the direction of the stack layout,
either \code{"horizontal"} or \code{"vertical"}.}

\item{...}{Additional arguments passed to \code{\link[=fortify_data_frame]{fortify_data_frame()}} or
\code{\link[=fortify_matrix]{fortify_matrix()}}.}

\item{theme}{A \code{\link[ggplot2:theme]{theme()}} used to render the \code{guides},
\code{title}, \code{subtitle}, \code{caption}, \code{margins}, \code{patch.title}, \code{panel.border}, and
\code{background}. If \code{NULL} (default), will inherit from the parent \code{layout}.}

\item{sizes}{A numeric or a \code{\link[grid:unit]{unit}} object of length \code{3}
indicating the relative heights (for \code{direction = "horizontal"}) or widths
(for \code{direction = "vertical"}).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{stack_align} function aligns observations, while \code{stack_free} does not.

Several aliases are provided for convenience:
\itemize{
\item \code{stack_alignv}: A special case of \code{stack_align} that sets \code{direction = "vertical"}.
\item \code{stack_alignh}: A special case of \code{stack_align} that sets \code{direction = "horizontal"}.
\item \code{stack_freev}: A special case of \code{stack_free} that sets \code{direction = "vertical"}.
\item \code{stack_freeh}: A special case of \code{stack_free} that sets \code{direction = "horizontal"}.
}
}
\examples{
set.seed(123)
stack_align(matrix(rnorm(56), nrow = 7L), "h") +
    align_dendro()
}
