% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcross.R
\name{ggcross}
\alias{ggcross}
\title{Connect two layout crosswise}
\usage{
ggcross(mapping = aes(), size = NULL, no_axes = NULL, active = NULL)
}
\arguments{
\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{size}{The relative size of the plot, can be specified as a
\code{\link[grid:unit]{unit()}}. Note that for \code{\link[=circle_layout]{circle_layout()}}, all size values
will be interpreted as relative sizes, as this layout type adjusts based on
the available space in the circular arrangement.}

\item{no_axes}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Logical; if \code{TRUE},
removes axes elements for the alignment axis using \code{\link[=theme_no_axes]{theme_no_axes()}}. By
default, will use the option-
\code{"ggalign.align_no_axes"}.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}
}
\description{
\code{ggcross} resets the layout ordering index of a \code{\link[=stack_cross]{stack_cross()}}. This
allows you to add other \verb{align_*} objects to define a new layout ordering
index. Any objects added after \code{ggcross} will use this updated layout
ordering index. This feature is particularly useful for creating \code{tanglegram}
visualizations. \code{ggcross()} is an alias of \code{ggcross()}.
}
\section{ggplot2 specification}{

\code{ggcross()} initializes a ggplot \code{data} and \code{mapping}.

\code{ggcross()} always applies a default mapping for the axis of the data index
in the layout. This mapping is \code{aes(y = .data$.y)} for horizontal stack
layout (including left and right annotation) and \code{aes(x = .data$.x)} for
vertical stack layout (including top and bottom annotation).

The data in the underlying \code{ggplot} object will contain following columns:
\itemize{
\item \code{.panel}: The panel for the aligned axis. Refers to the \code{x-axis} for
vertical \code{stack_layout()} (including top and bottom annotations), and the
\code{y-axis} for horizontal \code{stack_layout()} (including left and right
annotations).
\item \code{.names} (\code{\link[vctrs:vec_names]{vec_names()}}) and \code{.index}
(\code{\link[vctrs:vec_size]{vec_size()}}/\code{\link[=NROW]{NROW()}}): Character names (if
available) and the integer index of the original data.
\item \code{.hand}: a factor indicates the index groups.
\item \code{.x}/\code{.y} and \code{.discrete_x}/\code{.discrete_y}: Integer indices for \code{x}/\code{y}
coordinates, and a factor of the data labels (only applicable when names
exist).
}

It is recommended to use \code{.x}/\code{.y}, or \code{.discrete_x}/\code{.discrete_y} as the
\code{x}/\code{y} mapping.
}

