% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-.R
\name{is_layout}
\alias{is_layout}
\alias{is_quad_layout}
\alias{is_stack_layout}
\alias{is_stack_cross}
\alias{is_circle_layout}
\alias{is_heatmap_layout}
\alias{is_ggheatmap}
\title{Reports whether \code{x} is layout object}
\usage{
is_layout(x)

is_quad_layout(x)

is_stack_layout(x)

is_stack_cross(x)

is_circle_layout(x)

is_heatmap_layout(x)

is_ggheatmap(x)
}
\arguments{
\item{x}{An object to test.}
}
\value{
A single boolean value.
}
\description{
Reports whether \code{x} is layout object
}
\examples{
is_layout(ggheatmap(1:10))

# for quad_layout()
is_quad_layout(quad_alignb(1:10))
is_quad_layout(quad_alignh(1:10))
is_quad_layout(quad_alignv(1:10))
is_quad_layout(quad_free(mtcars))

# for stack_layout()
is_stack_layout(stack_discrete("h", 1:10))
is_stack_layout(stack_continuous("h", 1:10))

# for heatmap_layout()
is_heatmap_layout(ggheatmap(1:10))
is_ggheatmap(ggheatmap(1:10))
}
