% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_symmetric.R
\name{scale_x_symmetric}
\alias{scale_x_symmetric}
\title{Symmetric x continuous scale}
\usage{
scale_x_symmetric(
  ...,
  data = NULL,
  x = NULL,
  symmetric = TRUE,
  breaks = NULL,
  breaks_n = 6,
  expand = NULL,
  expand_limits = NULL,
  labels = NULL,
  position = "bottom",
  sec_axis = ggplot2::waiver(),
  transform = "identity"
)
}
\arguments{
\item{...}{Provided to force user argument naming etc.}

\item{data}{A data frame or tibble.}

\item{x}{An unquoted variable.}

\item{symmetric}{\code{TRUE} or \code{FALSE} of whether a symmetric scale.}

\item{breaks}{A \verb{scales::breaks_*} function (e.g. \verb{scales::breaks_*()}), or a vector of breaks.}

\item{breaks_n}{If \code{breaks = NULL}, the desired number of breaks.}

\item{expand}{Padding to the limits with the \code{\link[ggplot2:expansion]{ggplot2::expansion()}} function, or a vector of length 2 (e.g. \code{c(0, 0)}).}

\item{expand_limits}{Any values that the limits should encompass (e.g. \code{0}).}

\item{labels}{A function that takes the breaks as inputs (e.g. \verb{\\(x) stringr::str_to_sentence(x)} or \verb{scales::label_*()}), or a vector of labels.}

\item{position}{The position of the axis (i.e. \code{"left"}, \code{"right"}, \code{"bottom"} or \code{"top"}).}

\item{sec_axis}{A secondary axis created with \code{\link[ggplot2:sec_axis]{ggplot2::sec_axis()}} or \code{\link[ggplot2:sec_axis]{ggplot2::dup_axis()}}.}

\item{transform}{A transformation object (e.g. \code{\link[scales:transform_log]{scales::transform_log10()}}) or character string of this minus the \code{transform_} prefix (e.g. \code{"log10"}).}
}
\value{
A ggplot2 continuous x scale.
}
\description{
Symmetric x continuous scale
}
\keyword{internal}
