% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weave.R
\name{weave_mode}
\alias{weave_mode}
\title{Set the default mode}
\usage{
weave_mode(mode = light_mode_r())
}
\arguments{
\item{mode}{A new \verb{*_mode_*} theme (e.g. \code{\link[=dark_mode_r]{dark_mode_r()}}).}
}
\value{
A globally set mode
}
\description{
Set the default \code{mode} for \verb{gg_*} functions.
}
\examples{
library(ggplot2)
library(ggblanket)
library(palmerpenguins)

set_blanket()
weave_mode(dark_mode_r())

penguins |>
  gg_point(
    x = flipper_length_mm,
    y = body_mass_g,
    x_breaks = scales::breaks_pretty(3),
  )

weave_mode(dark_mode_r())

}
