% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_ideogram.R
\name{geom_ideogram}
\alias{geom_ideogram}
\title{Add Ideogram Annotation to Coverage Plot.}
\usage{
geom_ideogram(
  genome = "hg19",
  mark.color = "red",
  mark.alpha = 0.7,
  mark.line.size = 1,
  add.shadow = TRUE,
  shadow.color = "grey",
  shadow.alpha = 0.7,
  shadow.line.size = 1,
  plot.space = 0.1,
  plot.height = 0.1
)
}
\arguments{
\item{genome}{Single specie names, which must be one of the result from \code{ucscGenomes()$db}.
If missing, will invoke a menu for users to choose from. Default: hg19.}

\item{mark.color}{The color to mark plot region on ideogram. Default: "red".}

\item{mark.alpha}{The alpha to mark plot region on ideogram. Default: 0.7.}

\item{mark.line.size}{The line size to mark plot region on ideogram. Default: 1.}

\item{add.shadow}{Logical value, whether to add shadow polygon. Default: TRUE.}

\item{shadow.color}{The color to fill shadow polygon. Default: grey.}

\item{shadow.alpha}{The alpha of shadow polygon. Default: 0.7.}

\item{shadow.line.size}{The line size of shadow polygon. Default: 1.}

\item{plot.space}{Top and bottom margin. Default: 0.1.}

\item{plot.height}{The relative height of ideogram annotation to coverage plot. Default: 0.2.}
}
\value{
Plot.
}
\description{
Add Ideogram Annotation to Coverage Plot.
}
