% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_model.R
\name{simulate.dmc}
\alias{simulate.dmc}
\title{Simulate Responses from an EAM}
\usage{
\method{simulate}{dmc}(object, nsim = 2, seed = NULL, p.vector = NULL,
  SSD = Inf, staircase = NA, TRIALS = NA, ...)
}
\arguments{
\item{object}{is a DMC model object.}

\item{nsim}{nsim can be a single number for a balanced design or a vector
(one number per cell) to create an unbalanced design.}

\item{seed}{for compatible to \pkg{stats} simulate. Default NA}

\item{p.vector}{a parameter vector. Use Lognromal LBA model as an example,
\code{pVec <- c(A=.25, B=.35, meanlog_v.true=1, meanlog_v.false=.25,
sdlog_v.true=.5,t0=.2)}}

\item{SSD}{is for use only with stop-signal designs, it must be a scalar, or
a vector the same length as the number of cells or the same length as the
data and have Inf in all go cells}

\item{staircase}{is used only in stop-signal designs, overrides SSD, and
simulates a tracking algorighm setting SSD=start initially then moving up
step for each stop fail and down step for each stop-success.}

\item{TRIALS}{is a trial number covariate used in stop-signal paradimgs to
account for slowing or speeding over the course of the experiment.}

\item{...}{other arguments}
}
\description{
Simulate one or more responses from an EAM model object. This creates a data
frame using the model.
}
\details{
p.vector=ps[1,,drop=FALSE]; n=n[1,]; SSD=SSD[datr]
!!! TO DO !!!
!!! Add an update ability where n=data and RT is updated,
also on first creation add index to speed update
}
\examples{
model <- model.dmc(
   p.map     = list(a="1",v="1",z="1",d="1",sz="1",sv="1", t0="1",st0="1"),
   constants = c(st0=0,d=0),
   match.map = list(M=list(s1="r1",s2="r2")),
   factors   = list(S=c("s1","s2")),
   responses = c("r1","r2"),
   type      = "rd")

pop.prior <- prior.p.dmc(
  dists = rep("tnorm", 6),
  p1    = c(a=2,   v=2.5, z=0.5, sz=0.3, sv=1,  t0=0.3),
  p2    = c(a=0.5, v=.5,  z=0.1, sz=0.1, sv=.3, t0=0.05),
  lower = c(0,-5, 0, 0, 0, 0),
  upper = c(5, 7, 2, 2, 2, 2))

p.vector <- c(a=1,v=1, z=0.5, sz=0.25, sv=0.2,t0=.15)
d <- simulate(model, nsim=1e2, p.vector=p.vector)
head(d)
## dplyr::tbl_dt(d)
## Source: local data table [200 x 3]
##        S      R        RT
##    (fctr) (fctr)     (dbl)
## 1      s1     r1 0.6339412
## 2      s1     r2 0.5783174
## 3      s1     r2 0.2005078
## 4      s1     r1 0.2973437
## 5      s1     r2 0.4195281
## 6      s1     r2 0.1946740
## 7      s1     r1 0.2696773
## 8      s1     r1 0.3917966
## 9      s1     r1 0.8721902
## 10     s1     r1 0.2786452
## ..    ...    ...       ...
}

