% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dprior}
\alias{dprior}
\title{Calculate Prior Probability Density for an EAM}
\usage{
dprior(pVec, pPrior)
}
\arguments{
\item{pVec}{the user's supplied parameter vector or a sampler supplied
theta/phi vector.}

\item{pPrior}{a list of list usually created by prior.p.dmc to store the
prior parameter setting.}
}
\value{
a double vector with probability density for each model parameter
}
\description{
\code{dprior} is C++ function. It matches 5 string types: \code{tnorm},
\code{beta_lu}, \code{gamma_l}, \code{lnorm_l}, and \code{constant} to
determine which density functions to call (via R API). For truncated normal
density, \code{dprior} calls \code{dtn_scalar}, an internal Rcpp function
built specific for \pkg{ggdmc}. Whetehr log the probability density is
determined by the boolean \code{log} sent in via \code{p.prior}. This
function is akin to DMC's \code{log.prior.dmc}.
}
\examples{
## Use Drift-diffusion model as an example
ddm.prior <- prior.p.dmc(
dists = c("tnorm", "tnorm", "beta", "tnorm", "beta", "beta"),
p1    = c(a = 1, v = 0, z = 1, sz = 1, sv = 1, t0 = 1),
p2    = c(a = 1, v = 2, z = 1, sz = 1, sv = 1, t0 = 1),
lower = c(0,-5, NA, NA, 0, NA),
upper = c(2, 5, NA, NA, 2, NA))

view(ddm.prior)
##      mean sd lower upper log    dist  untrans
##   a     1  1     0     2   1   tnorm identity
##   v     0  2    -5     5   1   tnorm identity
##   z     1  1     0     1   1 beta_lu identity
##   sz    1  1  -Inf   Inf   1   tnorm identity
##   sv    1  1     0     2   1 beta_lu identity
##   t0    1  1     0     1   1 beta_lu identity

ddm.pVec <- c(a=1.15, v=-0.10, z=0.74, sz=1.23, sv=0.11, t0=0.87)
dprior(ddm.pVec, ddm.prior)
##         a          v          z         sz         sv         t0
##-0.5484734 -1.6008386  0.0000000 -0.9453885  0.0000000  0.0000000

## Use LBA model as an example
lba.prior <- prior.p.dmc(
dists = c("tnorm", "tnorm", "tnorm", "tnorm", "tnorm", "tnorm"),
p1    = c(A=.4, B=.6, mean_v.true=1,  mean_v.false=0,  sd_v.true=.5, t0=.3),
p2    = c(A=.1, B=.1, mean_v.true=.2, mean_v.false=.2, sd_v.true=.1, t0=.05),
lower = c(0,   0, NA, NA, 0, .1),
upper = c(NA, NA, NA, NA, NA, 1))

view(lba.prior)
##              mean   sd lower upper log  dist  untrans
## A             0.4  0.1     0   Inf   1 tnorm identity
## B             0.6  0.1     0   Inf   1 tnorm identity
## mean_v.true     1  0.2  -Inf   Inf   1 tnorm identity
## mean_v.false    0  0.2  -Inf   Inf   1 tnorm identity
## sd_v.true     0.5  0.1     0   Inf   1 tnorm identity
## t0            0.3 0.05   0.1     1   1 tnorm identity

lba.pVec <- c(A=0.398, B=0.614, mean_v.true=1.040,
              mean_v.false=-0.032, sd_v.true=0.485, t0=0.271)
dprior(lba.pVec, lba.prior)
##          A            B  mean_v.true mean_v.false    sd_v.true
##  1.3834782    1.3738466    0.6704994    0.6776994    1.3723968
}

