.runThisTest <- Sys.getenv("RunAllggeffectsTests") == "yes"

if (.runThisTest &&
    suppressWarnings(
  requiet("testthat") &&
  requiet("ggeffects") &&
  requiet("haven") &&
  requiet("sjlabelled") &&
  requiet("sjmisc")
)) {
  # lm, linear regression ----

  data(efc)
  efc$c172code <- to_label(efc$c172code)
  efc$e42dep <- to_label(efc$e42dep)
  efc$c82cop1 <- as.numeric(efc$c82cop1)
  fit <- lm(barthtot ~ c12hour + neg_c_7 + c82cop1 + e42dep + c161sex + c172code, data = efc)

  test_that("ggpredict, print", {
    ggpredict(fit, terms = "c12hour")
    ggpredict(fit, terms = "c172code")
    ggpredict(fit, terms = "c161sex")
    ggpredict(fit, terms = c("c12hour", "c172code"))
    ggpredict(fit, terms = c("c12hour", "c161sex"))
    ggpredict(fit, terms = c("e42dep", "c161sex"))
    ggpredict(fit, terms = c("e42dep", "c172code"))
    ggpredict(fit, terms = c("c12hour", "c172code", "c161sex"))
    ggpredict(fit, terms = c("e42dep", "c172code", "c161sex"))
    ggpredict(fit, terms = c("c12hour", "c172code", "e42dep"))
    ggpredict(fit, terms = c("c161sex", "c172code", "e42dep"))
    ggpredict(fit, terms = c("c12hour", "neg_c_7"))
    ggpredict(fit, terms = c("c12hour", "neg_c_7 [all]"))
    ggpredict(fit, terms = c("c12hour", "neg_c_7 [quart2]"))
    ggpredict(fit, terms = c("c12hour", "neg_c_7 [quart2]", "c161sex"))
    ggpredict(fit, terms = c("c12hour", "neg_c_7", "c161sex"))

    out <- utils::capture.output(ggpredict(fit, terms = c("c12hour", "neg_c_7 [quart2]", "c82cop1")))
    expect_equal(
      out,
      c("# Predicted values of Total score BARTHEL INDEX", "", "# neg_c_7 = 9",
        "# c82cop1 = 1", "", "c12hour | Predicted |          95% CI",
        "-------------------------------------", "      0 |     95.03 | [87.82, 102.24]",
        "     45 |     91.98 | [84.68,  99.29]", "     85 |     89.28 | [81.72,  96.83]",
        "    170 |     83.52 | [74.97,  92.07]", "", "# neg_c_7 = 11",
        "# c82cop1 = 1", "", "c12hour | Predicted |          95% CI",
        "-------------------------------------", "      0 |     93.03 | [85.96, 100.10]",
        "     45 |     89.98 | [82.83,  97.13]", "     85 |     87.27 | [79.88,  94.67]",
        "    170 |     81.52 | [73.13,  89.90]", "", "# neg_c_7 = 14",
        "# c82cop1 = 1", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     90.02 | [83.05, 97.00]",
        "     45 |     86.98 | [79.93, 94.02]", "     85 |     84.27 | [76.99, 91.54]",
        "    170 |     78.51 | [70.25, 86.77]", "", "# neg_c_7 = 9",
        "# c82cop1 = 2", "", "c12hour | Predicted |          95% CI",
        "-------------------------------------", "      0 |     94.45 | [88.66, 100.24]",
        "     45 |     91.40 | [85.53,  97.27]", "     85 |     88.69 | [82.53,  94.85]",
        "    170 |     82.93 | [75.64,  90.23]", "", "# neg_c_7 = 11",
        "# c82cop1 = 2", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     92.44 | [86.74, 98.14]",
        "     45 |     89.40 | [83.63, 95.17]", "     85 |     86.69 | [80.64, 92.74]",
        "    170 |     80.93 | [73.75, 88.12]", "", "# neg_c_7 = 14",
        "# c82cop1 = 2", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     89.44 | [83.71, 95.17]",
        "     45 |     86.39 | [80.61, 92.17]", "     85 |     83.68 | [77.65, 89.72]",
        "    170 |     77.93 | [70.78, 85.07]", "", "# neg_c_7 = 9",
        "# c82cop1 = 3", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     93.86 | [88.88, 98.84]",
        "     45 |     90.82 | [85.78, 95.86]", "     85 |     88.11 | [82.77, 93.45]",
        "    170 |     82.35 | [75.77, 88.93]", "", "# neg_c_7 = 11",
        "# c82cop1 = 3", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     91.86 | [86.88, 96.84]",
        "     45 |     88.81 | [83.78, 93.84]", "     85 |     86.10 | [80.79, 91.42]",
        "    170 |     80.35 | [73.81, 86.88]", "", "# neg_c_7 = 14",
        "# c82cop1 = 3", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     88.86 | [83.68, 94.03]",
        "     45 |     85.81 | [80.61, 91.00]", "     85 |     83.10 | [77.65, 88.55]",
        "    170 |     77.34 | [70.73, 83.95]", "", "# neg_c_7 = 9",
        "# c82cop1 = 4", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     93.28 | [88.19, 98.36]",
        "     45 |     90.23 | [85.12, 95.34]", "     85 |     87.52 | [82.14, 92.90]",
        "    170 |     81.77 | [75.21, 88.33]", "", "# neg_c_7 = 11",
        "# c82cop1 = 4", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     91.28 | [86.08, 96.47]",
        "     45 |     88.23 | [83.02, 93.43]", "     85 |     85.52 | [80.06, 90.98]",
        "    170 |     79.76 | [73.17, 86.36]", "", "# neg_c_7 = 14",
        "# c82cop1 = 4", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     88.27 | [82.75, 93.79]",
        "     45 |     85.22 | [79.71, 90.73]", "     85 |     82.52 | [76.79, 88.24]",
        "    170 |     76.76 | [69.97, 83.55]", "", "Adjusted for:",
        "*   e42dep =            independent", "*  c161sex =                   1.76",
        "* c172code = low level of education"),
      ignore_attr = TRUE)

    out <- utils::capture.output(ggpredict(fit, terms = c("c12hour", "neg_c_7", "c82cop1")))
    expect_equal(
      out,
      c("# Predicted values of Total score BARTHEL INDEX", "", "# neg_c_7 = 8",
        "# c82cop1 = 1", "", "c12hour | Predicted |          95% CI",
        "-------------------------------------", "      0 |     96.03 | [88.72, 103.34]",
        "     45 |     92.99 | [85.58, 100.39]", "     85 |     90.28 | [82.62,  97.93]",
        "    170 |     84.52 | [75.87,  93.17]", "", "# neg_c_7 = 11.8",
        "# c82cop1 = 1", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     92.23 | [85.20, 99.26]",
        "     45 |     89.18 | [82.08, 96.28]", "     85 |     86.47 | [79.12, 93.82]",
        "    170 |     80.71 | [72.37, 89.06]", "", "# neg_c_7 = 15.7",
        "# c82cop1 = 1", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     88.32 | [81.32, 95.32]",
        "     45 |     85.27 | [78.22, 92.33]", "     85 |     82.57 | [75.29, 89.84]",
        "    170 |     76.81 | [68.57, 85.05]", "", "# neg_c_7 = 8",
        "# c82cop1 = 2", "", "c12hour | Predicted |          95% CI",
        "-------------------------------------", "      0 |     95.45 | [89.58, 101.31]",
        "     45 |     92.40 | [86.45,  98.35]", "     85 |     89.69 | [83.45,  95.93]",
        "    170 |     83.94 | [76.56,  91.32]", "", "# neg_c_7 = 11.8",
        "# c82cop1 = 2", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     91.64 | [85.95, 97.33]",
        "     45 |     88.60 | [82.84, 94.35]", "     85 |     85.89 | [79.86, 91.91]",
        "    170 |     80.13 | [72.97, 87.29]", "", "# neg_c_7 = 15.7",
        "# c82cop1 = 2", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     87.74 | [81.90, 93.57]",
        "     45 |     84.69 | [78.82, 90.56]", "     85 |     81.98 | [75.87, 88.09]",
        "    170 |     76.22 | [69.04, 83.41]", "", "# neg_c_7 = 8",
        "# c82cop1 = 3", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     94.86 | [89.85, 99.88]",
        "     45 |     91.82 | [86.73, 96.90]", "     85 |     89.11 | [83.72, 94.50]",
        "    170 |     83.35 | [76.73, 89.98]", "", "# neg_c_7 = 11.8",
        "# c82cop1 = 3", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     91.06 | [86.04, 96.07]",
        "     45 |     88.01 | [82.96, 93.06]", "     85 |     85.30 | [79.97, 90.64]",
        "    170 |     79.55 | [73.01, 86.08]", "", "# neg_c_7 = 15.7",
        "# c82cop1 = 3", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     87.15 | [81.78, 92.53]",
        "     45 |     84.11 | [78.73, 89.48]", "     85 |     81.40 | [75.78, 87.01]",
        "    170 |     75.64 | [68.91, 82.37]", "", "# neg_c_7 = 8",
        "# c82cop1 = 4", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     94.28 | [89.21, 99.35]",
        "     45 |     91.23 | [86.13, 96.34]", "     85 |     88.52 | [83.14, 93.90]",
        "    170 |     82.77 | [76.20, 89.34]", "", "# neg_c_7 = 11.8",
        "# c82cop1 = 4", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     90.47 | [85.21, 95.74]",
        "     45 |     87.43 | [82.16, 92.69]", "     85 |     84.72 | [79.21, 90.23]",
        "    170 |     78.96 | [72.33, 85.59]", "", "# neg_c_7 = 15.7",
        "# c82cop1 = 4", "", "c12hour | Predicted |         95% CI",
        "------------------------------------", "      0 |     86.57 | [80.78, 92.36]",
        "     45 |     83.52 | [77.76, 89.28]", "     85 |     80.81 | [74.85, 86.77]",
        "    170 |     75.06 | [68.09, 82.03]", "", "Adjusted for:",
        "*   e42dep =            independent", "*  c161sex =                   1.76",
        "* c172code = low level of education"),
      ignore_attr = TRUE)
  })
}
