% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{plotPathOnAll}
\alias{plotPathOnAll}
\title{Plot a path between two vertices over the full genealogy}
\usage{
plotPathOnAll(path, geneal, ig, binVector = sample(1:12, 12))
}
\arguments{
  \item{path}{path as returned from getPath() or a vector
  of two variety names which exist in ig}

  \item{geneal}{the full genealogy (in data frame format)}

  \item{ig}{the graph representation of the data genealogy
  (in igraph format)}

  \item{binVector}{vector of numbers between 1 and
  length(binVector), each repeated exactly once}
}
\description{
This function requires a path and the ig object, and plots
the full genealogy with the path highlighted. The image
will correctly position the node labels with x-axis
representing the node year, and y-axis representing the
node path index. Light grey edges between two nodes
represent parent-child relationships between those nodes.
To enhance the visual understanding of how the
path-of-interest fits into the entire graph structure, the
nodes within the path are labelled in boldface, and
connected with light-green boldfaced edges.
}
\examples{
data(sbGeneal)
ig = dfToIG(sbGeneal)
path = getPath("Brim","Bedford",ig,sbGeneal)
binVector=sample(1:12, 12)
plotTotalImage <- plotPathOnAll(path=path, geneal=sbGeneal, ig=ig, binVector=sample(1:12, 12))
plotTotalImage
}
\seealso{
\url{http://www.r-project.org} for iGraph information

\code{\link{getPath}} for information on input path
building
}

