% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{getAncestors}
\alias{getAncestors}
\title{Returns a list of the ancestors of a particular variety (if they exist)}
\usage{
getAncestors(v1, geneal, gen = 3)
}
\arguments{
\item{v1}{the label of the variety/vertex of interest (in character string format)}

\item{geneal}{the full genealogy  (in data frame format)}

\item{gen}{the number of generations back to include as ancestors}
}
\description{
This function returns a list of the ancestors of the inputted variety within and including a given number of generations
}
\examples{
data(sbGeneal)
getParent("Essex", sbGeneal)
getAncestors("Essex", sbGeneal, 1)
getAncestors("Essex", sbGeneal, 5)
}

