% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_data_analysis.R
\name{ggmca}
\alias{ggmca}
\alias{ggmca_data}
\alias{ggmca_plot}
\title{Readable and Interactive graph for multiple correspondence analysis}
\usage{
ggmca(
  res.mca = res.mca,
  sup_vars,
  tooltip_vars_1lv,
  tooltip_vars,
  axes = c(1, 2),
  axes_names = NULL,
  type = c("text", "points", "labels", "active_vars_only", "numbers"),
  cleannames = TRUE,
  keep_levels,
  discard_levels,
  profiles = TRUE,
  profiles_tooltip_discard = "^Not |^No |^Pas |^Non ",
  cah,
  max_profiles,
  nb_char_for_color = rep(0, length(sup_vars)),
  text_repel = FALSE,
  title,
  actives_in_bold = FALSE,
  ellipses = NULL,
  xlim,
  ylim,
  out_lims_move = FALSE,
  color_profiles,
  base_profiles_color = "#dddddd",
  shift_colors = 0,
  colornames_recode,
  scale_color_light = material_colors_light(),
  scale_color_dark = material_colors_dark(),
  text_size = 3,
  size_scale_max = 8,
  dist_labels = c("auto", 0.04),
  right_margin = 0,
  use_theme = TRUE
)

ggmca_data(
  res.mca = res.mca,
  sup_vars,
  tooltip_vars_1lv,
  tooltip_vars,
  cleannames = TRUE,
  keep_levels,
  discard_levels,
  profiles = TRUE,
  profiles_tooltip_discard = "^Pas |^Non |^Not |^No ",
  cah,
  max_profiles,
  nb_char_for_color = rep(0, length(sup_vars))
)

ggmca_plot(
  data,
  axes = c(1, 2),
  axes_names = NULL,
  type = c("text", "points", "labels", "active_vars_only", "numbers", "facets"),
  text_repel = FALSE,
  title,
  actives_in_bold = FALSE,
  ellipses = NULL,
  xlim,
  ylim,
  out_lims_move = FALSE,
  color_profiles,
  base_profiles_color = "#dddddd",
  shift_colors = 0,
  colornames_recode,
  scale_color_light = material_colors_light(),
  scale_color_dark = material_colors_dark(),
  text_size = 3,
  size_scale_max = 8,
  dist_labels = c("auto", 0.04),
  right_margin = 0,
  use_theme = TRUE
)
}
\arguments{
\item{res.mca}{An object created with \code{FactoMineR::\link[FactoMineR]{MCA}}.}

\item{sup_vars}{A character vectors of supplementary qualitative variables
to print. They must have been passed in \code{\link[FactoMineR]{MCA}} before.}

\item{tooltip_vars_1lv}{A character vectors of variables, whose first level
(if character/factor) or weighted_mean (if numeric) will be added
at the top of interactive tooltips.}

\item{tooltip_vars}{A character vector of variables (character/factors),
whose complete levels will be added at the bottom of interactive tooltips.}

\item{axes}{The axes to print, as a numeric vector of length 2.}

\item{axes_names}{Names of all the axes (not just the two selected ones),
as a character vector.}

\item{type}{Determines the way \code{sup_vars} are printed.
  \itemize{
  \item \code{"text"} : colored text
  \item \code{"points"} : colored points with text legends
  \item \code{"labels"} : colored labels
  \item \code{"active_vars_only"} : no \code{sup_vars}
  \item \code{"numbers"} : colored labels of prefix numbers, with small names
  \item \code{"facets"} : one graph of profiles of answer for each levels of the
  first \code{sup_vars}. A different color is used for each.
}}

\item{cleannames}{Set to \code{TRUE} to clean levels names, by removing
prefix numbers like \code{"1-"}, and text in parentheses.}

\item{keep_levels}{A character vector of variables levels to keep : others
will be discarded.}

\item{discard_levels}{A character vector of variables levels to discard.}

\item{profiles}{When \code{TRUE}, profiles of answers are drawn in the back
of the graph with light-grey points. When hovering with mouse, the answers of
individuals to active variables will appears. If \code{cah} is provided,
to hover near one point will color all the points of the same
 \code{\link[FactoMineR]{HCPC}} class.}

\item{profiles_tooltip_discard}{A regex pattern to remove useless levels
among interactive tooltips for profiles of answers (ex. : levels expressing
"no" answers).}

\item{cah}{A variable made with \code{\link[FactoMineR]{HCPC}}, to link
the answers-profiles points who share the same ICPC class (will be colored
together at mouse hover).}

\item{max_profiles}{The maximum number of profiles points to print.}

\item{nb_char_for_color}{If \code{sup_vars} are prefixed with numbers, the
number of characters to use to create classes that will be used to add
colors to points.}

\item{text_repel}{When \code{TRUE} the graph is not interactive anymore,
but the resulting image is better to print because points and labels don't
overlaps. It uses \code{ggrepel::\link[ggrepel]{geom_text_repel}}.}

\item{title}{The title of the graph.}

\item{actives_in_bold}{Should active variables be in bold font, or sup variables ?}

\item{ellipses}{Set to a number between 0 and 1 to draw a concentration ellipse for
each level of the first \code{sup_vars}. \code{0.95} draw ellipses containing 95% of the
individuals of each category. \code{0.5} draw median-ellipses, containing half
the individuals of each category.}

\item{xlim, ylim}{Horizontal and vertical axes limits,
as double vectors of length 2.}

\item{out_lims_move}{When \code{TRUE}, the points out of \code{xlim} or
\code{ylim} are not removed, but moved at the edges of the graph.}

\item{color_profiles}{If \code{cah} is provided, should the answers profiles be
colored depending on their cah class ?}

\item{base_profiles_color}{The base color for answers profiles. Default to gray.
Set to `NULL` to discard profiles. With `color_profiles`, set to `NULL` to discard the
non-colored profiles.}

\item{shift_colors}{Change colors of the \code{sup_vars} points.}

\item{colornames_recode}{A named character vector with
\code{\link[forcats]{fct_recode}} style to rename the levels of the color
variable if needed (levels used for colors are printed in console message
whenever the function is used).}

\item{scale_color_light}{A scale color for sup vars points}

\item{scale_color_dark}{A scale color for sup vars texts}

\item{text_size}{Size of text.}

\item{size_scale_max}{Size of points.}

\item{dist_labels}{When \code{type = points}, the distance of labels
from points.}

\item{right_margin}{A margin at the right, in cm. Useful to read tooltips
over points placed at the right of the graph without formatting problems.}

\item{use_theme}{By default, a specific \pkg{ggplot2} theme is used.
Set to \code{FALSE} to customize your own \code{\link[ggplot2:theme]{theme}}.}

\item{data}{A list of data frames made with \link{ggmca_data}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object to be printed in the
`RStudio` Plots pane. Possibility to add other gg objects with \code{+}.
Sending the result through \code{\link{ggi}} will draw the
interactive graph in the Viewer pane using \code{\link{ggiraph}}.

A list containing the data frames to pass to \link{ggmca_plot}.

A \code{\link[ggplot2]{ggplot}} object.
}
\description{
A readable, complete and beautiful graph for multiple
correspondence analysis made with \code{FactoMineR::\link[FactoMineR]{MCA}}.
Interactive tooltips, appearing when hovering near points with mouse,
allow to keep in mind many important data (tables of active variables,
and additional chosen variables) while reading the graph.
Profiles of answers (from the graph of "individuals") are drawn in the back,
and can be linked to \code{FactoMineR::\link[FactoMineR]{HCPC}} classes.
Since it is made in the spirit of \code{\link{ggplot2}}, it is possible to
change theme or add another plot elements with \code{+}. Then, interactive
tooltips won't appear until you pass the result through \code{\link{ggi}}.
Step-by-step functions : use \link{ggmca_data} to get the data frames with every
parameter in a MCA printing, then modify, and pass to \link{ggmca_plot}
to draw the graph.
}
\section{Functions}{
\itemize{
\item \code{ggmca_data}: get the data frames with all parameters to print a MCA graph

\item \code{ggmca_plot}: print MCA graph from data frames with parameters
}}

\examples{
\donttest{
data(tea, package = "FactoMineR")
res.mca <- FactoMineR::MCA(tea, quanti.sup = 19, quali.sup = c(20:36), graph = FALSE)

res.mca \%>\%
  ggmca(sup_vars = c("SPC", "age_Q"), ylim = c(NA, 1.2)) \%>\%
  ggi()        #to make the graph interactive
#Concentration ellipses for each levels of a supplementary variable :
ggmca(res.mca, sup_vars = "SPC", ylim = c(NA, 1.2), ellipses = 0.5, text_repel = TRUE)

#Graph of profiles of answer for each levels of a supplementary variable :
ggmca(res.mca, sup_vars = "SPC", ylim = c(NA, 1.2), type = "facets", ellipses = 0.5)
}
}
