% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_changepoint.R
\name{autoplot.breakpoints}
\alias{autoplot.breakpoints}
\alias{autoplot.breakpointsfull}
\title{Autoplot \code{strucchange::breakpoints}}
\usage{
\method{autoplot}{breakpoints}(object, data = NULL, cpt.colour = "#FF0000",
  cpt.linetype = "dashed", ...)
}
\arguments{
\item{object}{\code{strucchange::breakpoints} or \code{strucchange::breakpointsfull} instance.}

\item{data}{Original time series. Mandatory for plotting \code{strucchange::breakpoints} instance.}

\item{cpt.colour}{Line colour for changepoints}

\item{cpt.linetype}{Line type for changepoints}

\item{...}{other arguments passed to \code{autoplot.ts}}
}
\value{
ggplot
}
\description{
Autoplot \code{strucchange::breakpoints}
}
\examples{
library(strucchange)
bp.nile <- breakpoints(Nile ~ 1)
autoplot(bp.nile)
autoplot(bp.nile, is.date = TRUE)
autoplot(breakpoints(bp.nile, breaks = 2), data = Nile)
}

