% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_polygonraster.R
\name{geom_polygonraster}
\alias{geom_polygonraster}
\title{Polygon parameterisation for rasters}
\usage{
geom_polygonraster(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = position_lineartrans(),
  ...,
  hjust = 0.5,
  vjust = 0.5,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{hjust, vjust}{horizontal and vertical justification of the grob.  Each
justification value should be a number between 0 and 1.  Defaults to 0.5
for both, centering each pixel over its data location.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \emph{Layer} ggproto object.
}
\description{
\code{geom_polygonraster} takes data that describes a raster with pixels of
the same size and reparametrises the data as a polygon. This allows for more
flexible transformations of the data, but comes at an efficiency cost.
}
\details{
For each pixel in a raster, makes a vertex for each of the four
corner points. These coordinates can then by transformed by
\code{coord}-functions such as \code{\link[ggplot2:coord_polar]{ggplot2::coord_polar()}} or
\code{position}-functions such as
\code{\link[=position_lineartrans]{position_lineartrans()}}. Currently substitutes group
aesthetics right before drawing in favour of pixel identifiers.
}
\section{Aesthetics}{


\code{geom_raster()} understands the following aesthetics (required
aesthetics are in bold):

\itemize{
\item \strong{x}
\item \strong{y}
\item fill
\item alpha
\item group
}
}

\examples{
# Combining with coord_polar()
ggplot(faithfuld, aes(waiting, eruptions)) +
  geom_polygonraster(aes(fill = density)) +
  coord_polar()

# Combining with linear transformations
df <- data.frame(x = row(volcano)[TRUE],
                 y = col(volcano)[TRUE],
                 z = volcano[TRUE])

ggplot(df, aes(x, y, fill = z)) +
  geom_polygonraster(position = position_lineartrans(angle = 30,
                                                     shear = c(1, 0)))
}
\seealso{
\code{\link[ggplot2:geom_tile]{geom_raster()}}
}
